"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLabel = exports.formatAlertResult = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _metric_value_formatter = require("../../../../../common/custom_threshold_rule/metric_value_formatter");
var _types = require("../../../../../common/custom_threshold_rule/types");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLabel = criterion => {
  if (!criterion.label && criterion.metrics.length === 1) {
    switch (criterion.metrics[0].aggType) {
      case _types.Aggregators.COUNT:
        return _translations.DOCUMENT_COUNT_I18N;
      case _types.Aggregators.AVERAGE:
        return (0, _translations.AVERAGE_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.P95:
        return (0, _translations.PERCENTILE_95_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.P99:
        return (0, _translations.PERCENTILE_99_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.RATE:
        return (0, _translations.RATE_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.MAX:
        return (0, _translations.MAX_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.MIN:
        return (0, _translations.MIN_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.CARDINALITY:
        return (0, _translations.CARDINALITY_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.SUM:
        return (0, _translations.SUM_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.LAST_VALUE:
        return (0, _translations.LAST_VALUE_I18N)(criterion.metrics[0].field);
      case _types.Aggregators.MED:
        return (0, _translations.MEDIAN_I18N)(criterion.metrics[0].field);
    }
  }
  return criterion.label || _translations.CUSTOM_EQUATION_I18N;
};
exports.getLabel = getLabel;
const formatAlertResult = evaluationResult => {
  var _metrics$0$field, _metrics$0$field2;
  const {
    metrics,
    currentValue,
    threshold,
    comparator
  } = evaluationResult;
  const noDataValue = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alerting.threshold.noDataFormattedValue', {
    defaultMessage: '[NO DATA]'
  });
  const label = getLabel(evaluationResult);
  const perSecIfRate = metrics[0].aggType === _types.Aggregators.RATE ? '/s' : '';
  const eventsAsUnit = metrics[0].aggType === _types.Aggregators.RATE && !((_metrics$0$field = metrics[0].field) !== null && _metrics$0$field !== void 0 && _metrics$0$field.endsWith('.pct')) && !((_metrics$0$field2 = metrics[0].field) !== null && _metrics$0$field2 !== void 0 && _metrics$0$field2.endsWith('.bytes')) ? ` ${_constants.EventsAsUnit}` : '';
  const rateUnitPerSec = eventsAsUnit + perSecIfRate;
  return {
    ...evaluationResult,
    currentValue: currentValue !== null && currentValue !== undefined ? (0, _metric_value_formatter.metricValueFormatter)(currentValue, metrics[0].field) + rateUnitPerSec : noDataValue,
    label: label || _translations.CUSTOM_EQUATION_I18N,
    threshold: Array.isArray(threshold) ? threshold.map(v => (0, _metric_value_formatter.metricValueFormatter)(v, metrics[0].field) + rateUnitPerSec) : [(0, _metric_value_formatter.metricValueFormatter)(currentValue, metrics[0].field) + rateUnitPerSec],
    comparator
  };
};
exports.formatAlertResult = formatAlertResult;