"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewLineAnnotation = NewLineAnnotation;
exports.ObsLineAnnotation = ObsLineAnnotation;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _lodash = require("lodash");
var _ = require(".");
var _annotation_tooltip = require("./annotation_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/new_line_annotation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function NewLineAnnotation({
  slo,
  isCreateOpen
}) {
  const {
    watch,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const eventEnd = watch('event.end');
  if (eventEnd || !isCreateOpen) {
    return null;
  }
  const values = getValues();
  const annotationStyle = watch('annotation.style');
  const annotationType = watch('annotation.type');
  return /*#__PURE__*/_react.default.createElement(ObsLineAnnotation, {
    annotation: (0, _lodash.cloneDeep)({
      ...values,
      annotation: {
        ...values.annotation,
        style: annotationStyle,
        type: annotationType
      },
      ...(slo ? {
        slo: {
          id: slo.id,
          instanceId: slo.instanceId
        }
      } : {})
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
}
function ObsLineAnnotation({
  annotation
}) {
  var _annotation$annotatio, _line$width, _annotation$annotatio2, _annotation$annotatio3, _line$width2, _line$width3, _line$width4, _line$width5, _annotation$annotatio4, _annotation$annotatio5, _annotation$annotatio6, _annotation$annotatio7, _annotation$annotatio8;
  const timestamp = annotation['@timestamp'];
  const message = annotation.message;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const line = (_annotation$annotatio = annotation.annotation.style) === null || _annotation$annotatio === void 0 ? void 0 : _annotation$annotatio.line;
  return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: 'id' in annotation ? annotation.id : `${timestamp}${message}`,
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [{
      dataValue: (0, _moment.default)(timestamp).valueOf(),
      details: message,
      header: annotation.message
    }],
    style: {
      line: {
        strokeWidth: (_line$width = line === null || line === void 0 ? void 0 : line.width) !== null && _line$width !== void 0 ? _line$width : 2,
        stroke: (_annotation$annotatio2 = annotation === null || annotation === void 0 ? void 0 : (_annotation$annotatio3 = annotation.annotation.style) === null || _annotation$annotatio3 === void 0 ? void 0 : _annotation$annotatio3.color) !== null && _annotation$annotatio2 !== void 0 ? _annotation$annotatio2 : euiTheme.colors.warning,
        opacity: 1,
        ...((line === null || line === void 0 ? void 0 : line.style) === 'dashed' && {
          dash: [((_line$width2 = line === null || line === void 0 ? void 0 : line.width) !== null && _line$width2 !== void 0 ? _line$width2 : 2) * 3, (_line$width3 = line === null || line === void 0 ? void 0 : line.width) !== null && _line$width3 !== void 0 ? _line$width3 : 2]
        }),
        ...((line === null || line === void 0 ? void 0 : line.style) === 'dotted' && {
          dash: [(_line$width4 = line === null || line === void 0 ? void 0 : line.width) !== null && _line$width4 !== void 0 ? _line$width4 : 2, (_line$width5 = line === null || line === void 0 ? void 0 : line.width) !== null && _line$width5 !== void 0 ? _line$width5 : 2]
        })
      }
    },
    marker: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_.AnnotationIcon, {
      annotation: annotation,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    })),
    markerBody: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "annotation-marker-body",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }, (_annotation$annotatio4 = (_annotation$annotatio5 = annotation.annotation) === null || _annotation$annotatio5 === void 0 ? void 0 : _annotation$annotatio5.title) !== null && _annotation$annotatio4 !== void 0 ? _annotation$annotatio4 : annotation.message),
    markerPosition: (_annotation$annotatio6 = (_annotation$annotatio7 = annotation.annotation.style) === null || _annotation$annotatio7 === void 0 ? void 0 : (_annotation$annotatio8 = _annotation$annotatio7.line) === null || _annotation$annotatio8 === void 0 ? void 0 : _annotation$annotatio8.iconPosition) !== null && _annotation$annotatio6 !== void 0 ? _annotation$annotatio6 : 'top',
    customTooltip: () => /*#__PURE__*/_react.default.createElement(_annotation_tooltip.AnnotationTooltip, {
      annotation: annotation,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 28
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
}