"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.topLevelRoutes = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
var _create_or_update_conversation_index_assets = require("../../service/index_assets/create_or_update_conversation_index_assets");
var _create_or_update_knowledge_base_index_assets = require("../../service/index_assets/create_or_update_knowledge_base_index_assets");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createOrUpdateIndexAssetsRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/index_assets',
  params: t.type({
    query: t.type({
      inference_id: t.string
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const {
      inference_id: inferenceId
    } = resources.params.query;
    await (0, _create_or_update_conversation_index_assets.createOrUpdateConversationIndexAssets)({
      logger: resources.logger,
      core: resources.plugins.core.setup
    });
    return (0, _create_or_update_knowledge_base_index_assets.createOrUpdateKnowledgeBaseIndexAssets)({
      logger: resources.logger,
      core: resources.plugins.core.setup,
      inferenceId
    });
  }
});
const topLevelRoutes = exports.topLevelRoutes = {
  ...createOrUpdateIndexAssetsRoute
};