"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStorybookService = exports.createStorybookChatService = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _builders = require("./utils/builders");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/storybook_mock.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createStorybookChatService = () => ({
  sendAnalyticsEvent: () => {},
  chat: options => new _rxjs.Observable(),
  complete: options => new _rxjs.Observable(),
  getFunctions: () => [(0, _builders.buildFunctionElasticsearch)(), (0, _builders.buildFunctionServiceSummary)()],
  renderFunction: name => /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.chatService.div.helloLabel', {
    defaultMessage: 'Hello'
  }), name),
  hasFunction: () => true,
  hasRenderFunction: () => true,
  getSystemMessage: () => 'System',
  functions$: new _rxjs.BehaviorSubject([]),
  getScopes: () => ['all']
});
exports.createStorybookChatService = createStorybookChatService;
const createStorybookService = () => ({
  isEnabled: () => true,
  start: async () => {
    return createStorybookChatService();
  },
  callApi: {},
  register: () => {},
  setScreenContext: () => _lodash.noop,
  getScreenContexts: () => [],
  conversations: {
    openNewConversation: _lodash.noop,
    predefinedConversation$: new _rxjs.Observable()
  },
  navigate: async () => (0, _rxjs.of)(),
  scope$: new _rxjs.BehaviorSubject(['all']),
  getScopes: () => ['all'],
  setScopes: () => {}
});
exports.createStorybookService = createStorybookService;