"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseEditUserInstructionFlyout = KnowledgeBaseEditUserInstructionFlyout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _use_get_user_instructions = require("../../hooks/use_get_user_instructions");
var _use_create_knowledge_base_user_instruction = require("../../hooks/use_create_knowledge_base_user_instruction");
var _use_delete_knowledge_base_entry = require("../../hooks/use_delete_knowledge_base_entry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/knowledge_base_edit_user_instruction_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function KnowledgeBaseEditUserInstructionFlyout({
  onClose
}) {
  const [newEntryText, setNewEntryText] = (0, _react.useState)('');
  const [newEntryId, setNewEntryId] = (0, _react.useState)();
  const {
    userInstructions,
    isLoading: isFetching
  } = (0, _use_get_user_instructions.useGetUserInstructions)();
  const {
    mutateAsync: createOrUpdateEntry,
    isLoading: isSaving
  } = (0, _use_create_knowledge_base_user_instruction.useCreateKnowledgeBaseUserInstruction)();
  const {
    mutate: deleteEntry
  } = (0, _use_delete_knowledge_base_entry.useDeleteKnowledgeBaseEntry)();
  (0, _react.useEffect)(() => {
    var _userInstruction$text;
    const userInstruction = userInstructions === null || userInstructions === void 0 ? void 0 : userInstructions.find(entry => !entry.public);
    setNewEntryText((_userInstruction$text = userInstruction === null || userInstruction === void 0 ? void 0 : userInstruction.text) !== null && _userInstruction$text !== void 0 ? _userInstruction$text : '');
    setNewEntryId(userInstruction === null || userInstruction === void 0 ? void 0 : userInstruction.id);
  }, [userInstructions]);
  const handleSubmit = async () => {
    if (newEntryId && !newEntryText) {
      deleteEntry({
        id: newEntryId,
        isUserInstruction: true
      });
    } else {
      await createOrUpdateEntry({
        entry: {
          id: newEntryId !== null && newEntryId !== void 0 ? newEntryId : (0, _uuid.v4)(),
          text: newEntryText,
          public: false // limit user instructions to private (for now)
        }
      });
    }
    onClose();
  };
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "knowledgeBaseManualEntryFlyout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditSystemPrompt.h2.editEntryLabel', {
    defaultMessage: 'User-specific System Prompt'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditSystemPromptFlyout.personalPromptTextLabel', {
    defaultMessage: 'This user-specific prompt will be appended to the system prompt. It is space-aware and will only be used for your prompts - not shared with other users.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    editorId: "knowledgeBaseEditManualEntryFlyoutMarkdownEditor",
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.euiMarkdownEditor.observabilityAiAssistantKnowledgeBaseViewMarkdownEditorLabel', {
      defaultMessage: 'observabilityAiAssistantKnowledgeBaseViewMarkdownEditor'
    }),
    height: 300,
    initialViewMode: "editing",
    readOnly: isFetching,
    placeholder: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiMarkdownEditor.enterContentsLabel', {
      defaultMessage: 'Enter contents'
    }),
    value: newEntryText,
    onChange: text => setNewEntryText(text),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutCancelButton",
    disabled: isSaving,
    onClick: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.cancelButtonEmptyLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutSaveButton",
    fill: true,
    isLoading: isSaving,
    disabled: newEntryText.trim().length === 0 && !newEntryId,
    onClick: handleSubmit,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))));
}