"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSchemaToOpenApi = convertSchemaToOpenApi;
var _lodash = require("lodash");
var _zodToJsonSchema = _interopRequireDefault(require("zod-to-json-schema"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function dropUnknownProperties(object) {
  if (!(0, _lodash.isPlainObject)(object)) {
    return object;
  }
  (0, _lodash.forEach)(object, (value, key) => {
    switch (key) {
      case 'type':
      case 'minLength':
      case 'maxLength':
      case 'required':
      case 'description':
        break;
      case 'enum':
      case 'const':
      case 'items':
      case 'allOf':
      case 'anyOf':
      case 'oneOf':
        (0, _lodash.castArray)(value).forEach(innerSchema => {
          if ((0, _lodash.isPlainObject)(innerSchema)) {
            dropUnknownProperties(innerSchema);
          }
        });
        break;
      case 'properties':
        (0, _lodash.forEach)(object.properties, (propertyValue, propertyKey) => {
          dropUnknownProperties(propertyValue);
        });
        break;
      default:
        (0, _lodash.unset)(object, key);
        break;
    }
  });
  return object;
}
function convertSchemaToOpenApi(typeSchema) {
  // @ts-ignore
  const plainOpenApiSchema = (0, _zodToJsonSchema.default)(typeSchema, {
    target: 'openApi3',
    $refStrategy: 'none'
  });
  return dropUnknownProperties(plainOpenApiSchema);
}