"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmIndices = getApmIndices;
var _server = require("@kbn/core/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmIndices({
  core,
  plugins,
  logger
}) {
  const [coreStart] = await core.getStartServices();
  const savedObjectsClient = new _server.SavedObjectsClient(coreStart.savedObjects.createInternalRepository());
  try {
    return plugins.apmDataAccess.getApmIndices(savedObjectsClient);
  } catch (error) {
    logger.warn(`Failed to resolve APM indices for Observability Agent: ${error.message}`);
    return {
      error: 'apm-error-*',
      metric: 'apm-metric-*',
      onboarding: 'apm-onboarding-*',
      span: 'apm-span-*',
      transaction: 'apm-transaction-*',
      sourcemap: 'apm-sourcemap-*'
    };
  }
}