"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableHead = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/shard_allocation/components/table_head.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class IndexLabel extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      showSystemIndices: props.showSystemIndices
    };
    this.toggleShowSystemIndicesState = this.toggleShowSystemIndicesState.bind(this);
  }
  toggleShowSystemIndicesState(e) {
    const isChecked = e.target.checked;
    this.setState({
      showSystemIndices: isChecked
    });
    this.props.toggleShowSystemIndices(isChecked);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.shardAllocation.tableHead.indicesLabel",
      defaultMessage: "Indices",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.tableHead.filterSystemIndices', {
        defaultMessage: 'Filter for system indices'
      }),
      onChange: this.toggleShowSystemIndicesState,
      checked: this.state.showSystemIndices,
      "data-test-subj": "shardShowSystemIndices",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    })));
  }
}

// eslint-disable-next-line react/no-multi-comp
class TableHead extends _react.default.Component {
  constructor(props) {
    super(props);
  }
  createColumn({
    key,
    content
  }) {
    return /*#__PURE__*/_react.default.createElement("th", {
      scope: "col",
      key: key,
      colSpan: 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }, content);
  }
  render() {
    const propLabels = this.props.labels || [];
    const labelColumns = propLabels.map(label => {
      const column = {
        key: label.content.toLowerCase()
      };
      if (label.showToggleSystemIndicesComponent) {
        // override text label content with a JSX component
        column.content = /*#__PURE__*/_react.default.createElement(IndexLabel, {
          toggleShowSystemIndices: this.props.toggleShowSystemIndices,
          showSystemIndices: this.props.showSystemIndices,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 13
          }
        });
      } else {
        column.content = label.content;
      }
      return column;
    }).map(this.createColumn);
    return /*#__PURE__*/_react.default.createElement("thead", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("tr", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }, labelColumns));
  }
}
exports.TableHead = TableHead;