"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.swimLaneComparators = exports.initializeSwimLaneControls = void 0;
var _rxjs = require("rxjs");
var _explorer_constants = require("../../application/explorer/explorer_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const swimLaneComparators = exports.swimLaneComparators = {
  jobIds: 'deepEquality',
  swimlaneType: 'referenceEquality',
  viewBy: 'referenceEquality',
  perPage: 'referenceEquality'
};
const initializeSwimLaneControls = (rawState, titlesApi) => {
  var _rawState$perPage;
  const jobIds = new _rxjs.BehaviorSubject(rawState.jobIds);
  const swimlaneType = new _rxjs.BehaviorSubject(rawState.swimlaneType);
  const viewBy = new _rxjs.BehaviorSubject(rawState.swimlaneType === 'viewBy' ? rawState.viewBy : undefined);
  const fromPage = new _rxjs.BehaviorSubject(1);
  const perPage = new _rxjs.BehaviorSubject((_rawState$perPage = rawState.perPage) !== null && _rawState$perPage !== void 0 ? _rawState$perPage : _explorer_constants.SWIM_LANE_DEFAULT_PAGE_SIZE);
  const updateUserInput = update => {
    jobIds.next(update.jobIds);
    swimlaneType.next(update.swimlaneType);
    viewBy.next(update.viewBy);
    titlesApi.setTitle(update.panelTitle);
  };
  const updatePagination = update => {
    fromPage.next(update.fromPage);
    if (update.perPage) {
      perPage.next(update.perPage);
    }
  };
  const subscription = (0, _rxjs.combineLatest)([jobIds, swimlaneType, viewBy]).subscribe(() => {
    updatePagination({
      fromPage: 1
    });
  });
  const getLatestState = () => {
    return {
      jobIds: jobIds.value,
      swimlaneType: swimlaneType.value,
      viewBy: viewBy.value,
      perPage: perPage.value
    };
  };
  return {
    api: {
      jobIds,
      swimlaneType,
      viewBy,
      fromPage,
      perPage,
      updateUserInput,
      updatePagination
    },
    anyStateChange$: (0, _rxjs.merge)(jobIds, swimlaneType, viewBy, perPage).pipe((0, _rxjs.map)(() => undefined)),
    getLatestState,
    reinitializeState: lastSavedState => {
      jobIds.next(lastSavedState.jobIds);
      swimlaneType.next(lastSavedState.swimlaneType);
      viewBy.next(lastSavedState.viewBy);
      perPage.next(lastSavedState.perPage);
    },
    cleanup: () => {
      subscription.unsubscribe();
      jobIds.complete();
      swimlaneType.complete();
      viewBy.complete();
      fromPage.complete();
      perPage.complete();
    }
  };
};
exports.initializeSwimLaneControls = initializeSwimLaneControls;