"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _explorer_anomalies_container = require("../../application/explorer/explorer_charts/explorer_anomalies_container");
var _locator = require("../../../common/constants/locator");
var _triggers = require("../../ui_actions/triggers");
var _use_anomaly_charts_data = require("./use_anomaly_charts_data");
var _explorer_utils = require("../../application/explorer/explorer_utils");
var _job_service = require("../../application/services/job_service");
var _use_threshold_to_severity = require("../../application/explorer/hooks/use_threshold_to_severity");
var _severity_format_resolver = require("../../application/components/controls/select_severity/severity_format_resolver");
var _select_severity = require("../../application/components/controls/select_severity/select_severity");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/anomaly_charts/anomaly_charts_react_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RESIZE_THROTTLE_TIME_MS = 500;
const AnomalyChartsContainer = ({
  id,
  timeRange$,
  severityThreshold,
  services,
  onRenderComplete,
  onError,
  onLoading,
  api,
  showFilterIcons = true
}) => {
  const isMounted = (0, _useMountedState.default)();
  const [tableData, setTableData] = (0, _react.useState)({
    anomalies: [],
    examplesByJobId: {},
    interval: 0,
    jobIds: [],
    showViewSeriesLink: false
  });
  const [chartWidth, setChartWidth] = (0, _react.useState)(0);
  const thresholdsToSeverity = (0, _use_threshold_to_severity.useThresholdToSeverity)();

  // Define a default threshold to use when severityThreshold is undefined (embeddable creation)
  const {
    val: defaultThreshold
  } = (0, _select_severity.useDefaultSeverity)();

  // Initialize severity state from props or default
  const [severity, setSeverity] = (0, _react.useState)(thresholdsToSeverity(severityThreshold !== undefined ? (0, _severity_format_resolver.resolveSeverityFormat)(severityThreshold) : defaultThreshold));

  // Extract thresholds from severity objects for API updates and data fetching
  const severityThresholds = (0, _react.useMemo)(() => severity.map(s => s.threshold), [severity]);
  const [selectedEntities, setSelectedEntities] = (0, _react.useState)();
  const [{
    uiSettings
  }, {
    data: dataServices,
    share,
    uiActions,
    charts: chartsService
  }, {
    mlApi
  }] = services;
  const mlJobService = (0, _job_service.useMlJobService)();
  const {
    timefilter
  } = dataServices.query.timefilter;
  const timeRange = (0, _useObservable.default)(timeRange$);
  const mlLocator = (0, _react.useMemo)(() => share.url.locators.get(_locator.ML_APP_LOCATOR), [share]);
  const timeBuckets = (0, _react.useMemo)(() => {
    return new _mlTimeBuckets.TimeBuckets({
      'histogram:maxBars': uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      'histogram:barTarget': uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (api !== null && api !== void 0 && api.updateSeverityThreshold) {
      api.updateSeverityThreshold(severityThresholds);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [severityThresholds, api === null || api === void 0 ? void 0 : api.updateSeverityThreshold]);
  (0, _react.useEffect)(() => {
    if (api !== null && api !== void 0 && api.updateSelectedEntities) {
      api.updateSelectedEntities(selectedEntities);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedEntities, api === null || api === void 0 ? void 0 : api.updateSelectedEntities]);
  const renderCallbacks = (0, _react.useMemo)(() => {
    return {
      onRenderComplete,
      onError,
      onLoading
    };
  }, [onRenderComplete, onError, onLoading]);
  const {
    chartsData,
    isLoading: isExplorerLoading,
    error
  } = (0, _use_anomaly_charts_data.useAnomalyChartsData)(api, services, chartWidth, severityThresholds, renderCallbacks);
  const dateFormatTz = (0, _explorer_utils.useDateFormatTz)();
  (0, _react.useEffect)(() => {
    // async IFEE
    (async () => {
      if (chartsData === undefined) {
        return;
      }
      try {
        var _chartsData$seriesToP;
        await mlJobService.loadJobsWrapper();
        const explorerJobs = (_chartsData$seriesToP = chartsData.seriesToPlot.map(({
          jobId,
          bucketSpanSeconds
        }) => {
          return {
            id: jobId,
            selected: true,
            bucketSpanSeconds,
            modelPlotEnabled: false
          };
        })) !== null && _chartsData$seriesToP !== void 0 ? _chartsData$seriesToP : [];
        const timeRangeBounds = {
          min: (0, _momentTimezone.default)(chartsData.seriesToPlot[0].plotEarliest),
          max: (0, _momentTimezone.default)(chartsData.seriesToPlot[0].plotLatest)
        };
        const newTableData = await (0, _explorer_utils.loadAnomaliesTableData)(mlApi, mlJobService, undefined, explorerJobs, dateFormatTz, timeRangeBounds, 'job ID', 'auto', {
          val: [{
            min: 0
          }]
        });
        if (isMounted()) {
          setTableData(newTableData);
        }
      } catch (err) {
        console.log(err); // eslint-disable-line no-console
      }
    })();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartsData]);

  // Holds the container height for previously fetched data
  const containerHeightRef = (0, _react.useRef)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const resizeHandler = (0, _react.useCallback)((0, _lodash.throttle)(e => {
    // Keep previous container height so it doesn't change the page layout
    if (!isExplorerLoading) {
      containerHeightRef.current = e.height;
    }
    if (Math.abs(chartWidth - e.width) > 20) {
      setChartWidth(e.width);
    }
  }, RESIZE_THROTTLE_TIME_MS), [!isExplorerLoading, chartWidth]);
  const containerHeight = (0, _react.useMemo)(() => {
    // Persists container height during loading to prevent page from jumping
    return isExplorerLoading ? containerHeightRef.current : undefined;
  }, [isExplorerLoading]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: false,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomalyChartsEmbeddable.errorMessage",
        defaultMessage: "Unable to load the data for the anomaly charts",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 11
        }
      }),
      color: "danger",
      iconType: "warning",
      css: {
        width: '100%'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }, error.message));
  }
  const addEntityFieldFilter = (fieldName, fieldValue, operation) => {
    const entity = {
      fieldName,
      fieldValue,
      operation
    };
    const uniqueSelectedEntities = [entity];
    setSelectedEntities(uniqueSelectedEntities);
    uiActions.getTrigger(_triggers.EXPLORER_ENTITY_FIELD_SELECTION_TRIGGER).exec({
      embeddable: api,
      data: uniqueSelectedEntities
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: resizeHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 5
    }
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    id: `mlAnomalyExplorerEmbeddableWrapper-${id}`,
    style: {
      width: '100%',
      overflowY: 'auto',
      overflowX: 'hidden',
      padding: '8px',
      height: containerHeight
    },
    "data-test-subj": `mlExplorerEmbeddable_${id}`,
    ref: resizeRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }, isExplorerLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: 'center',
    css: {
      position: 'absolute',
      top: '50%',
      left: '50%',
      transform: 'translate(-50%,-50%)'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl",
    "data-test-subj": "mlAnomalyExplorerEmbeddableLoadingIndicator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 15
    }
  })), chartsData !== undefined && isExplorerLoading === false ? /*#__PURE__*/_react.default.createElement(_explorer_anomalies_container.ExplorerAnomaliesContainer, {
    id: id,
    showCharts: true,
    chartsData: chartsData,
    severity: severityThresholds,
    setSeverity: setSeverity,
    mlLocator: mlLocator,
    tableData: tableData,
    timeBuckets: timeBuckets,
    timefilter: timefilter,
    onSelectEntity: addEntityFieldFilter,
    showSelectedInterval: false,
    chartsService: chartsService,
    timeRange: timeRange,
    showFilterIcons: showFilterIcons,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 13
    }
  }) : null));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = exports.default = AnomalyChartsContainer;
module.exports = exports.default;