"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRouteResolver = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _access_denied = require("../access_denied");
var _app = require("../../../common/constants/app");
var _kibana = require("../contexts/kibana");
var _check_capabilities = require("../capabilities/check_capabilities");
var _locator = require("../../../common/constants/locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/use_resolver.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Resolves required dependencies for landing on the page
 * and performs redirects if needed.
 *
 * @param requiredLicense
 * @param requiredCapabilities
 */
const useRouteResolver = (requiredLicense, requiredCapabilities, customResolvers) => {
  const requiredCapabilitiesRef = (0, _react.useRef)(requiredCapabilities);
  const customResolversRef = (0, _react.useRef)(customResolvers);
  const [results, setResults] = (0, _react.useState)();
  const [context, setContext] = (0, _react.useState)({
    initialized: false
  });
  const {
    services: {
      application: {
        navigateToApp,
        navigateToUrl
      },
      mlServices: {
        mlCapabilities
      },
      uiSettings,
      data: {
        dataViews
      },
      notifications,
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const mlLicenseInfo = (0, _kibana.useMlLicenseInfo)();
  (0, _useMount.default)(function refreshCapabilitiesOnMount() {
    mlCapabilities.refreshCapabilities();
  });
  const licenseResolver = (0, _react.useCallback)(async () => {
    if (mlLicenseInfo.isMlEnabled === false || mlLicenseInfo.isMinimumLicense === false) {
      // ML is not enabled or the license isn't at least basic
      await navigateToApp('home');
      return Promise.reject();
    }
    if (requiredLicense === 'full' && mlLicenseInfo.isFullLicense === false) {
      // ML is enabled, but only with a basic or gold license
      await navigateToApp(_app.PLUGIN_ID, {
        path: _locator.ML_PAGES.DATA_VISUALIZER
      });
      return Promise.reject();
    }
    if (mlLicenseInfo.hasLicenseExpired) {
      await navigateToUrl(await locators.get('LICENSE_MANAGEMENT_LOCATOR').getUrl({
        page: 'dashboard'
      }));
      return Promise.reject();
    }
    return true;
  }, [locators, mlLicenseInfo.hasLicenseExpired, mlLicenseInfo.isFullLicense, mlLicenseInfo.isMinimumLicense, mlLicenseInfo.isMlEnabled, navigateToApp, navigateToUrl, requiredLicense]);

  // Check if the user has all required permissions
  const capabilitiesResults = (0, _check_capabilities.usePermissionCheck)(requiredCapabilities);
  const capabilitiesResolver = (0, _react.useCallback)(async () => {
    const missingCapabilities = requiredCapabilitiesRef.current.filter((k, i) => !capabilitiesResults[i]);
    if (missingCapabilities.length > 0) {
      setContext({
        initialized: true,
        resolvedComponent: /*#__PURE__*/_react.default.createElement(_access_denied.AccessDeniedCallout, {
          missingCapabilities: missingCapabilities,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 28
          }
        })
      });
      return Promise.reject();
    }
    return true;
  }, [capabilitiesResults]);
  const resolveCustomResolvers = (0, _react.useCallback)(async () => {
    if (!customResolversRef.current) return;
    const funcNames = Object.keys(customResolversRef.current); // Object.entries gets this wrong?!
    const funcs = Object.values(customResolversRef.current); // Object.entries gets this wrong?!
    const tempResults = funcNames.reduce((p, c) => {
      p[c] = {};
      return p;
    }, {});
    const res = await Promise.all(funcs.map(r => r(mlApi)));
    res.forEach((r, i) => tempResults[funcNames[i]] = r);
    return tempResults;
    // skip mlApi from deps
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function resolveRequirements() {
    let mounted = true;

    // Sequence is important
    licenseResolver().then(capabilitiesResolver).then(resolveCustomResolvers).then(customResults => {
      if (mounted) {
        setContext({
          initialized: true
        });
        setResults(customResults);
      }
    }).catch(rejectedValue => {
      if (rejectedValue instanceof Error) {
        notifications.toasts.addError(rejectedValue, {
          title: _i18n.i18n.translate('xpack.ml.useResolver.errorTitle', {
            defaultMessage: 'An error has occurred'
          })
        });
      }
    });
    return () => {
      mounted = false;
    };
  }, [licenseResolver, mlLicenseInfo, capabilitiesResolver, notifications.toasts, resolveCustomResolvers, dataViews, uiSettings]);
  return {
    context,
    results
  };
};
exports.useRouteResolver = useRouteResolver;