"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClassColor = getClassColor;
exports.getClassIcon = getClassIcon;
exports.getClassLabel = getClassLabel;
exports.getNerOutputComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _inference_base = require("../inference_base");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_models/models/ner/ner_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const badgeColorPaletteBorder = (0, _eui.euiPaletteColorBlind)();
const badgeColorPaletteBehindText = (0, _eui.euiPaletteColorBlindBehindText)();
const ICON_PADDING = '2px';
const PROBABILITY_SIG_FIGS = 3;
const ENTITY_TYPE_NAMES = ['PER', 'LOC', 'ORG', 'MISC'];
const isEntityTypeName = name => ENTITY_TYPE_NAMES.includes(name);
const ENTITY_TYPES = {
  PER: {
    label: 'Person',
    icon: 'user',
    colorIndex: 9
  },
  LOC: {
    label: 'Location',
    icon: 'visMapCoordinate',
    colorIndex: 2
  },
  ORG: {
    label: 'Organization',
    icon: 'home',
    colorIndex: 0
  },
  MISC: {
    label: 'Miscellaneous',
    icon: 'question',
    colorIndex: 8
  }
};
const UNKNOWN_ENTITY_TYPE = {
  label: '',
  icon: 'question',
  colorIndex: 9
};
const getNerOutputComponent = inferrer => /*#__PURE__*/_react.default.createElement(NerOutput, {
  inferrer: inferrer,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 66
  }
});
exports.getNerOutputComponent = getNerOutputComponent;
const NerOutput = ({
  inferrer
}) => {
  const result = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (!result) {
    return null;
  }
  if (inferrer.getInputType() === _inference_base.INPUT_TYPE.INDEX) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, result.map(r => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Lines, {
      result: r,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(Lines, {
    result: result[0],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 10
    }
  });
};
const Lines = ({
  result
}) => {
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs', {
    unit: 'px'
  }).fontSize;
  const lineSplit = [];
  result.response.forEach(({
    value,
    entity
  }) => {
    if (entity === null) {
      const lines = value.split(/(\n)/).map(line => line === '\n' ? /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 41
        }
      }) : /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 50
        }
      }, line));
      lineSplit.push(...lines);
    } else {
      lineSplit.push(/*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: getClassIcon(entity.class_name),
          style: {
            marginRight: ICON_PADDING,
            verticalAlign: 'text-top'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 17
          }
        }), value), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
          margin: "none",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement("div", {
          style: {
            fontSize: euiFontSizeXS,
            marginTop: ICON_PADDING
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 123,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 124,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.testModelsFlyout.ner.output.typeTitle",
          defaultMessage: "Type",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 125,
            columnNumber: 19
          }
        }), ": ", getClassLabel(entity.class_name)), /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.testModelsFlyout.ner.output.probabilityTitle",
          defaultMessage: "Probability",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 19
          }
        }), ": ", Number(entity.class_probability).toPrecision(PROBABILITY_SIG_FIGS)))),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(EntityBadge, {
        entity: entity,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 11
        }
      }, value)));
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      lineHeight: '24px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 10
    }
  }, lineSplit);
};
const EntityBadge = ({
  entity,
  children
}) => {
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs').fontSize;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: getClassColor(entity.class_name),
    style: {
      marginRight: ICON_PADDING,
      marginTop: `-${ICON_PADDING}`,
      fontSize: euiFontSizeXS,
      padding: '0px 6px',
      pointerEvents: 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: getClassIcon(entity.class_name),
    style: {
      marginRight: ICON_PADDING,
      marginTop: ICON_PADDING
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, children)));
};
function getClassIcon(className) {
  var _entity$icon;
  const entity = ENTITY_TYPES[className];
  return (_entity$icon = entity === null || entity === void 0 ? void 0 : entity.icon) !== null && _entity$icon !== void 0 ? _entity$icon : UNKNOWN_ENTITY_TYPE.icon;
}
function getClassLabel(className) {
  var _entity$label;
  const entity = ENTITY_TYPES[className];
  return (_entity$label = entity === null || entity === void 0 ? void 0 : entity.label) !== null && _entity$label !== void 0 ? _entity$label : className;
}
function getClassColor(className, border = false) {
  const colorIndex = isEntityTypeName(className) ? ENTITY_TYPES[className].colorIndex : UNKNOWN_ENTITY_TYPE.colorIndex;
  return border ? badgeColorPaletteBorder[colorIndex] : badgeColorPaletteBehindText[colorIndex];
}