"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatePipelineForModelFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _constants = require("../../components/ml_inference/constants");
var _shared = require("../../components/shared");
var _state = require("./state");
var _pipeline_details = require("./pipeline_details");
var _test_trained_model = require("./test_trained_model");
var _kibana = require("../../contexts/kibana");
var _get_pipeline_config = require("./get_pipeline_config");
var _validation = require("../../components/ml_inference/validation");
var _use_fetch_pipelines = require("../../components/ml_inference/hooks/use_fetch_pipelines");
var _test_trained_models_context = require("../test_models/test_trained_models_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/create_pipeline_for_model/create_pipeline_for_model_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreatePipelineForModelFlyout = ({
  onClose,
  model
}) => {
  const {
    currentContext: {
      pipelineConfig
    }
  } = (0, _test_trained_models_context.useTestTrainedModelsContext)();
  const initialState = (0, _react.useMemo)(() => (0, _state.getInitialState)(model, pipelineConfig),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [model.model_id, pipelineConfig]);
  const [formState, setFormState] = (0, _react.useState)(initialState);
  const [step, setStep] = (0, _react.useState)(_constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS);
  const [hasUnsavedChanges, setHasUnsavedChanges] = (0, _react.useState)(false);
  const taskType = (0, _react.useMemo)(() => {
    var _model$inference_conf;
    return Object.keys((_model$inference_conf = model.inference_config) !== null && _model$inference_conf !== void 0 ? _model$inference_conf : {})[0];
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [model.model_id]);
  const {
    trainedModels: {
      createInferencePipeline
    }
  } = (0, _kibana.useMlApi)();
  const createPipeline = async () => {
    setFormState({
      ...formState,
      creatingPipeline: true
    });
    try {
      const config = (0, _get_pipeline_config.getPipelineConfig)(formState);
      await createInferencePipeline(formState.pipelineName, config);
      setFormState({
        ...formState,
        pipelineCreated: true,
        creatingPipeline: false,
        pipelineError: undefined
      });
    } catch (e) {
      var _errorProperties$mess;
      // eslint-disable-next-line no-console
      console.error(e);
      const errorProperties = (0, _mlErrorUtils.extractErrorProperties)(e);
      setFormState({
        ...formState,
        creatingPipeline: false,
        pipelineError: (_errorProperties$mess = errorProperties.message) !== null && _errorProperties$mess !== void 0 ? _errorProperties$mess : e.message
      });
    }
  };
  const pipelineNames = (0, _use_fetch_pipelines.useFetchPipelines)();
  const handleConfigUpdate = configUpdate => {
    const updatedState = {
      ...formState,
      ...configUpdate
    };
    setFormState(updatedState);
  };
  const handleSetStep = currentStep => {
    setStep(currentStep);
  };
  const {
    pipelineName: pipelineNameError
  } = (0, _react.useMemo)(() => {
    const errors = (0, _validation.validateInferencePipelineConfigurationStep)(formState.pipelineName, pipelineNames);
    return errors;
  }, [pipelineNames, formState.pipelineName]);
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'mlInferencePipelineFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose.bind(null, true),
    size: "l",
    "data-test-subj": "mlTrainedModelsFromTestInferencePipelineFlyout",
    includeFixedHeadersInFocusTrap: false,
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.createInferencePipeline.title', {
    defaultMessage: 'Create inference pipeline'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.AddInferencePipelineHorizontalSteps, {
    step: step,
    setStep: handleSetStep,
    isDetailsStepValid: pipelineNameError === undefined,
    isConfigureProcessorStepValid: hasUnsavedChanges === false,
    hasProcessorStep: false,
    pipelineCreated: formState.pipelineCreated,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS && /*#__PURE__*/_react.default.createElement(_pipeline_details.PipelineDetails, {
    handlePipelineConfigUpdate: handleConfigUpdate,
    pipelineName: formState.pipelineName,
    pipelineNameError: pipelineNameError,
    pipelineDescription: formState.pipelineDescription,
    modelId: model.model_id,
    taskType: taskType,
    initialPipelineConfig: formState.initialPipelineConfig,
    setHasUnsavedChanges: setHasUnsavedChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE && /*#__PURE__*/_react.default.createElement(_shared.OnFailureConfiguration, {
    ignoreFailure: formState.ignoreFailure,
    takeActionOnFailure: formState.takeActionOnFailure,
    handleAdvancedConfigUpdate: handleConfigUpdate,
    onFailure: formState.onFailure,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.TEST && /*#__PURE__*/_react.default.createElement(_test_trained_model.TestTrainedModel, {
    model: model,
    handlePipelineConfigUpdate: handleConfigUpdate,
    externalPipelineConfig: (0, _get_pipeline_config.getPipelineConfig)(formState),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.CREATE && /*#__PURE__*/_react.default.createElement(_shared.ReviewAndCreatePipeline, {
    highlightTargetField: true,
    inferencePipeline: (0, _get_pipeline_config.getPipelineConfig)(formState),
    pipelineName: formState.pipelineName,
    pipelineCreated: formState.pipelineCreated,
    pipelineError: formState.pipelineError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "mlTrainedModelsInferencePipelineFlyoutFooter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.AddInferencePipelineFooter, {
    onClose: onClose,
    onCreate: createPipeline,
    step: step,
    setStep: handleSetStep,
    isDetailsStepValid: pipelineNameError === undefined,
    isConfigureProcessorStepValid: hasUnsavedChanges === false,
    pipelineCreated: formState.pipelineCreated,
    creatingPipeline: formState.creatingPipeline,
    hasProcessorStep: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  })));
};
exports.CreatePipelineForModelFlyout = CreatePipelineForModelFlyout;