"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMemoryUsage = void 0;
var _react = require("react");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _use_refresh = require("../routing/use_refresh");
var _trained_models = require("../services/ml_api_service/trained_models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMemoryUsage = (node, type) => {
  const [loading, setLoading] = (0, _react.useState)(false);
  const [data, setData] = (0, _react.useState)([]);
  const [error, setError] = (0, _react.useState)();
  const refresh = (0, _use_refresh.useRefresh)();
  const trainedModelsApiService = (0, _trained_models.useTrainedModelsApiService)();
  const isMounted = (0, _useMountedState.default)();
  (0, _react.useEffect)(function getMemoryData() {
    const fetchData = async () => {
      setLoading(true);
      try {
        const resp = await trainedModelsApiService.memoryUsage(type, node);
        setError(undefined);
        setData(resp);
      } catch (e) {
        const err = (0, _mlErrorUtils.extractErrorProperties)(e);
        setError(err.message);
      }
      setLoading(false);
    };
    if (!isMounted()) return;
    fetchData();
  }, [node, type, trainedModelsApiService, isMounted, refresh]);
  return {
    loading,
    data,
    error
  };
};
exports.useMemoryUsage = useMemoryUsage;