"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllocatedModels = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
var _ml = require("../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/memory_usage/nodes_overview/allocated_models.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AllocatedModels = ({
  models,
  hideColumns = ['node_name']
}) => {
  const bytesFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const dateFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);
  const durationFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DURATION);
  const euiTheme = (0, _eui.useEuiTheme)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const columns = [{
    width: '10%',
    id: 'deployment_id',
    field: 'deployment_id',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.deploymentIdHeader', {
      defaultMessage: 'ID'
    }),
    sortable: true,
    truncateText: false,
    isExpander: false,
    'data-test-subj': 'mlAllocatedModelsTableDeploymentId'
  }, {
    width: '8%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelRoutingStateHeader', {
      defaultMessage: 'State'
    }),
    'data-test-subj': 'mlAllocatedModelsTableRoutingState',
    render: v => {
      const {
        routing_state: routingState,
        reason
      } = v.node.routing_state;
      const isFailed = routingState === 'failed';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: reason ? reason : '',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        tabIndex: 0,
        color: isFailed ? 'danger' : 'hollow',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 13
        }
      }, routingState));
    }
  }, {
    width: '8%',
    id: 'node_name',
    field: 'node.name',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.nodeNameHeader', {
      defaultMessage: 'Node name'
    }),
    sortable: true,
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableNodeName'
  }, {
    width: '10%',
    id: 'model_id',
    field: 'model_id',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelNameHeader', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableName'
  }, {
    width: '8%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelSizeHeader', {
      defaultMessage: 'Size'
    }),
    truncateText: true,
    'data-test-subj': 'mlAllocatedModelsTableSize',
    render: v => {
      return bytesFormatter(v.required_native_memory_bytes);
    }
  }, {
    width: '8%',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: showNodeInfo ? _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.allocationTooltipNodes', {
        defaultMessage: 'Number of allocations per node multiplied by number of threads per allocation'
      }) : _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.allocationTooltip', {
        defaultMessage: 'Number of allocations multiplied by number of threads per allocation'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.allocationHeader', {
      defaultMessage: 'Allocation'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 13
      }
    }))),
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableAllocation',
    render: v => {
      var _v$adaptive_allocatio;
      if (v.node.number_of_allocations === undefined || v.node.threads_per_allocation === undefined) {
        return '-';
      }
      let adaptiveAllocations = null;
      if ((_v$adaptive_allocatio = v.adaptive_allocations) !== null && _v$adaptive_allocatio !== void 0 && _v$adaptive_allocatio.enabled) {
        adaptiveAllocations = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.adaptiveAllocationsTooltip', {
            defaultMessage: 'Adaptive allocations enabled'
          }),
          size: "l",
          color: "warning",
          type: "scale",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 151,
            columnNumber: 13
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, v.node.number_of_allocations, " * ", v.node.threads_per_allocation), adaptiveAllocations);
    }
  }, {
    width: '8%',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.throughputLastMinuteTooltip', {
        defaultMessage: 'The number of requests processed in the last 1 minute.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.throughputLastMinuteHeader', {
      defaultMessage: 'Throughput'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 13
      }
    }))),
    field: 'node.throughput_last_minute',
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableThroughput'
  }, {
    width: '8%',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: 'block',
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.nodesList.modelsList.modelAvgInferenceTimeTooltipHeader",
        defaultMessage: "Average inference time",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 13
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.nodesList.modelsList.modelAvgInferenceTimeTooltipMessage",
        defaultMessage: "If caching is enabled, fast cache hits are included when calculating the average inference time.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      tabIndex: 0,
      gutterSize: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        minWidth: 0
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: {
        overflow: 'hidden',
        textOverflow: 'ellipsis'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.nodesList.modelsList.modelAvgInferenceTimeHeader",
      defaultMessage: "Avg inference time",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        minWidth: euiTheme.euiTheme.size.m
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 15
      }
    })))),
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableAvgInferenceTime',
    render: v => {
      return v.node.average_inference_time_ms ? durationFormatter(v.node.average_inference_time_ms) : '-';
    }
  }, {
    width: '8%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelInferenceCountHeader', {
      defaultMessage: 'Inference count'
    }),
    'data-test-subj': 'mlAllocatedModelsTableInferenceCount',
    render: v => {
      return v.node.inference_count;
    }
  }, {
    width: '12%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelStartTimeHeader', {
      defaultMessage: 'Start time'
    }),
    'data-test-subj': 'mlAllocatedModelsTableStartedTime',
    render: v => {
      return v.node.start_time ? dateFormatter(v.node.start_time) : '-';
    }
  }, {
    width: '12%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelLastAccessHeader', {
      defaultMessage: 'Last access'
    }),
    'data-test-subj': 'mlAllocatedModelsTableInferenceCount',
    render: v => {
      return v.node.last_access ? dateFormatter(v.node.last_access) : '-';
    }
  }, {
    width: '8%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelNumberOfPendingRequestsHeader', {
      defaultMessage: 'Pending requests'
    }),
    'data-test-subj': 'mlAllocatedModelsTableNumberOfPendingRequests',
    render: v => {
      return v.node.number_of_pending_requests;
    }
  }, {
    width: '8%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.errorCountHeader', {
      defaultMessage: 'Errors'
    }),
    'data-test-subj': 'mlAllocatedModelsTableErrorCount',
    render: v => {
      var _v$node$error_count;
      return (_v$node$error_count = v.node.error_count) !== null && _v$node$error_count !== void 0 ? _v$node$error_count : 0;
    }
  }].filter(v => !hideColumns.includes(v.id));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    responsiveBreakpoint: 'xl',
    allowNeutralSort: false,
    columns: columns,
    items: models,
    itemId: 'key',
    rowProps: item => ({
      'data-test-subj': `mlAllocatedModelTableRow row-${item.model_id}`
    }),
    onTableChange: () => {},
    "data-test-subj": 'mlNodesAllocatedModels',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 5
    }
  });
};
exports.AllocatedModels = AllocatedModels;