"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewGroupInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _validate_job = require("../../../validate_job");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/multi_job_actions/group_selector/new_group_input/new_group_input.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class NewGroupInput extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "changeTempNewGroup", e => {
      const tempNewGroupName = e.target.value;
      let groupsValidationError = '';
      if (tempNewGroupName === '') {
        groupsValidationError = '';
      } else if (this.props.allJobIds.includes(tempNewGroupName)) {
        groupsValidationError = _i18n.i18n.translate('xpack.ml.jobsList.multiJobActions.groupSelector.groupsAndJobsCanNotUseSameIdErrorMessage', {
          defaultMessage: 'A job with this ID already exists. Groups and jobs cannot use the same ID.'
        });
      } else {
        groupsValidationError = (0, _validate_job.validateGroupNames)([tempNewGroupName]).message;
      }
      this.setState({
        tempNewGroupName,
        groupsValidationError
      });
    });
    (0, _defineProperty2.default)(this, "newGroupKeyPress", e => {
      if (e.key === _eui.keys.ENTER && this.state.groupsValidationError === '' && this.state.tempNewGroupName !== '') {
        this.addNewGroup();
      }
    });
    (0, _defineProperty2.default)(this, "addNewGroup", () => {
      this.props.addNewGroup(this.state.tempNewGroupName);
      this.setState({
        tempNewGroupName: ''
      });
    });
    this.state = {
      tempNewGroupName: '',
      groupsValidationError: ''
    };
  }
  render() {
    const {
      tempNewGroupName,
      groupsValidationError
    } = this.state;
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "rowCompressed",
      isInvalid: groupsValidationError !== '',
      error: groupsValidationError,
      className: "new-group-input",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      placeholder: _i18n.i18n.translate('xpack.ml.jobsList.multiJobActions.groupSelector.addNewGroupPlaceholder', {
        defaultMessage: 'Add new group'
      }),
      value: tempNewGroupName,
      onChange: this.changeTempNewGroup,
      onKeyDown: this.newGroupKeyPress,
      isInvalid: groupsValidationError !== '',
      error: groupsValidationError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "new-group-input",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: this.addNewGroup,
      iconType: "plusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.multiJobActions.groupSelector.addButtonAriaLabel', {
        defaultMessage: 'Add'
      }),
      disabled: tempNewGroupName === '' || groupsValidationError !== '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 15
      }
    })))));
  }
}
exports.NewGroupInput = NewGroupInput;
(0, _defineProperty2.default)(NewGroupInput, "propTypes", {
  addNewGroup: _propTypes.default.func.isRequired,
  allJobIds: _propTypes.default.array.isRequired
});