"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiJobActionsMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _check_ml_nodes = require("../../../../ml_nodes_check/check_ml_nodes");
var _jobs_utils = require("../../../jobs_utils");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/multi_job_actions/actions_menu.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class MultiJobActionsMenuUI extends _react.Component {
  constructor(props, constructorContext) {
    super(props, constructorContext);
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(prevState => ({
        isOpen: !prevState.isOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isOpen: false
      });
    });
    this.state = {
      isOpen: false
    };
    this.canDeleteJob = (0, _check_capabilities.checkPermission)('canDeleteJob');
    this.canStartStopDatafeed = (0, _check_capabilities.checkPermission)('canStartStopDatafeed') && (0, _check_ml_nodes.mlNodesAvailable)();
    this.canCloseJob = (0, _check_capabilities.checkPermission)('canCloseJob') && (0, _check_ml_nodes.mlNodesAvailable)();
    this.canResetJob = (0, _check_capabilities.checkPermission)('canResetJob') && (0, _check_ml_nodes.mlNodesAvailable)();
    this.canCreateMlAlerts = (0, _check_capabilities.checkPermission)('canCreateMlAlerts');
    this.toastNotifications = constructorContext.services.notifications.toasts;
    this.mlApi = constructorContext.services.mlServices.mlApi;
  }
  render() {
    const anyJobsBlocked = this.props.jobs.some(j => j.blocked !== undefined);
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      onClick: this.onButtonClick,
      iconType: "gear",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.multiJobActionsMenu.managementActionsAriaLabel', {
        defaultMessage: 'Management actions'
      }),
      color: "text",
      disabled: anyJobsBlocked || this.canDeleteJob === false && this.canStartStopDatafeed === false,
      "data-test-subj": "mlADJobListMultiSelectManagementActionsButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    });
    const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "delete",
      icon: "trash",
      disabled: this.canDeleteJob === false,
      onClick: () => {
        this.props.showDeleteJobModal(this.props.jobs);
        this.closePopover();
      },
      "data-test-subj": "mlADJobListMultiSelectDeleteJobActionButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.multiJobsActions.deleteJobsLabel",
      defaultMessage: "Delete {jobsCount, plural, one {job} other {jobs}}",
      values: {
        jobsCount: this.props.jobs.length
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }))];
    if ((0, _utils.isClosable)(this.props.jobs)) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "close job",
        icon: "cross",
        disabled: this.canCloseJob === false,
        onClick: () => {
          if (this.props.jobs.some(j => (0, _jobs_utils.isManagedJob)(j))) {
            this.props.showCloseJobsConfirmModal(this.props.jobs);
          } else {
            (0, _utils.closeJobs)(this.toastNotifications, this.mlApi, this.props.jobs);
          }
          this.closePopover();
        },
        "data-test-subj": "mlADJobListMultiSelectCloseJobActionButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.multiJobsActions.closeJobsLabel",
        defaultMessage: "Close {jobsCount, plural, one {job} other {jobs}}",
        values: {
          jobsCount: this.props.jobs.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      })));
    }
    if ((0, _utils.isResettable)(this.props.jobs)) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "reset job",
        icon: "refresh",
        disabled: this.canCloseJob === false,
        onClick: () => {
          this.props.showResetJobModal(this.props.jobs);
          this.closePopover();
        },
        "data-test-subj": "mlADJobListMultiSelectResetJobActionButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.multiJobsActions.resetJobsLabel",
        defaultMessage: "Reset {jobsCount, plural, one {job} other {jobs}}",
        values: {
          jobsCount: this.props.jobs.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 11
        }
      })));
    }
    if ((0, _utils.isStoppable)(this.props.jobs)) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "stop datafeed",
        icon: "stop",
        disabled: this.canStartStopDatafeed === false,
        onClick: () => {
          if (this.props.jobs.some(j => (0, _jobs_utils.isManagedJob)(j))) {
            this.props.showStopDatafeedsConfirmModal(this.props.jobs);
          } else {
            (0, _utils.stopDatafeeds)(this.toastNotifications, this.mlApi, this.props.jobs, this.props.refreshJobs);
          }
          this.closePopover();
        },
        "data-test-subj": "mlADJobListMultiSelectStopDatafeedActionButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.multiJobsActions.stopDatafeedsLabel",
        defaultMessage: "Stop {jobsCount, plural, one {datafeed} other {datafeeds}}",
        values: {
          jobsCount: this.props.jobs.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 11
        }
      })));
    }
    if ((0, _utils.isStartable)(this.props.jobs)) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "start datafeed",
        icon: "play",
        disabled: this.canStartStopDatafeed === false,
        onClick: () => {
          this.props.showStartDatafeedModal(this.props.jobs);
          this.closePopover();
        },
        "data-test-subj": "mlADJobListMultiSelectStartDatafeedActionButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.multiJobsActions.startDatafeedsLabel",
        defaultMessage: "Start {jobsCount, plural, one {datafeed} other {datafeeds}}",
        values: {
          jobsCount: this.props.jobs.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 11
        }
      })));
    }
    if (this.canCreateMlAlerts && this.props.jobs.length === 1) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "create alert",
        icon: "bell",
        disabled: false,
        onClick: () => {
          this.props.showCreateAlertFlyout(this.props.jobs.map(({
            id
          }) => id));
          this.closePopover();
        },
        "data-test-subj": "mlADJobListMultiSelectCreateAlertActionButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.multiJobsActions.createAlertsLabel",
        defaultMessage: "Create alert rule",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 11
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: button,
      isOpen: this.state.isOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downCenter",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items.reverse(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 9
      }
    }));
  }
}
(0, _defineProperty2.default)(MultiJobActionsMenuUI, "contextType", _public.context);
MultiJobActionsMenuUI.propTypes = {
  jobs: _propTypes.default.array.isRequired,
  showStartDatafeedModal: _propTypes.default.func.isRequired,
  showDeleteJobModal: _propTypes.default.func.isRequired,
  showStopDatafeedsConfirmModal: _propTypes.default.func.isRequired,
  refreshJobs: _propTypes.default.func.isRequired,
  showCreateAlertFlyout: _propTypes.default.func.isRequired
};
const MultiJobActionsMenu = exports.MultiJobActionsMenu = MultiJobActionsMenuUI;