"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _constants = require("@kbn/deeplinks-management/constants");
var _common = require("@kbn/cases-plugin/common");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _common2 = require("../../../../common");
var _alerts = require("../../../../common/constants/alerts");
var _alert_actions = require("../../../alerting/anomaly_detection_alerts_table/alert_actions");
var _alerts_table_flyout = require("../../../alerting/anomaly_detection_alerts_table/alerts_table_flyout");
var _collapsible_panel = require("../../components/collapsible_panel");
var _kibana = require("../../contexts/kibana");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
var _alerts_summary = require("./alerts_summary");
var _chart = require("./chart");
var _const = require("./const");
var _render_cell_value = require("../../../alerting/anomaly_detection_alerts_table/render_cell_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/alerts/alerts_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const columns = [{
  id: _ruleDataUtils.ALERT_STATUS,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.status', {
    defaultMessage: 'Status'
  }),
  initialWidth: 150
}, {
  id: _ruleDataUtils.ALERT_REASON,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.reason', {
    defaultMessage: 'Reason'
  }),
  initialWidth: 150
}, {
  id: _ruleDataUtils.ALERT_RULE_NAME,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.ruleName', {
    defaultMessage: 'Rule name'
  }),
  initialWidth: 150
}, {
  id: _alerts.ALERT_ANOMALY_DETECTION_JOB_ID,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.jobId', {
    defaultMessage: 'Job ID'
  }),
  initialWidth: 150
}, {
  id: _alerts.ALERT_ANOMALY_SCORE,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.anomalyScore', {
    defaultMessage: 'Latest anomaly score'
  }),
  initialWidth: 150,
  isSortable: true
}, {
  id: _ruleDataUtils.ALERT_START,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.triggeredAt', {
    defaultMessage: 'Triggered at'
  }),
  initialWidth: 250,
  schema: 'datetime'
}, {
  id: _ruleDataUtils.ALERT_END,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.recoveredAt', {
    defaultMessage: 'Recovered at'
  }),
  initialWidth: 250,
  schema: 'datetime'
}, {
  id: _alerts.ALERT_ANOMALY_TIMESTAMP,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.anomalyTime', {
    defaultMessage: 'Latest anomaly time'
  }),
  initialWidth: 250,
  schema: 'datetime'
}, {
  id: _ruleDataUtils.ALERT_DURATION,
  displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.duration', {
    defaultMessage: 'Duration'
  }),
  initialWidth: 150,
  schema: 'numeric'
}];
const sort = [{
  [_ruleDataUtils.ALERT_START]: {
    order: 'desc'
  }
}];
const AlertsPanel = () => {
  const {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    settings
  } = (0, _kibana.useMlKibana)().services;
  const [isOpen, setIsOpen] = (0, _react.useState)(true);
  const [toggleSelected, setToggleSelected] = (0, _react.useState)(`alertsSummary`);
  const {
    anomalyDetectionAlertsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const countByStatus = (0, _useObservable.default)(anomalyDetectionAlertsStateService.countByStatus$);
  const alertsQuery = (0, _useObservable.default)(anomalyDetectionAlertsStateService.alertsQuery$, {});
  const isLoading = (0, _useObservable.default)(anomalyDetectionAlertsStateService.isLoading$, true);
  const toggleButtons = [{
    id: `alertsSummary`,
    label: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summaryLabel', {
      defaultMessage: 'Summary'
    })
  }, {
    id: `alertsTable`,
    label: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.detailsLabel', {
      defaultMessage: 'Details'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
    isOpen: isOpen,
    onToggle: setIsOpen,
    header: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: 'center',
      gutterSize: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.alertsPanel.header",
      defaultMessage: "Alerts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 15
      }
    })), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: 'm',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 17
      }
    })) : null),
    headerItems: Object.entries(countByStatus !== null && countByStatus !== void 0 ? countByStatus : {}).map(([status, count]) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _const.statusNameMap[status], ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        size: "m",
        color: status === _ruleDataUtils.ALERT_STATUS_ACTIVE ? 'accent' : 'subdued',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 15
        }
      }, count));
    }),
    ariaLabel: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.ariaLabel', {
      defaultMessage: 'alerts panel'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.AnomalyDetectionAlertsOverviewChart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summaryTableToggle', {
      defaultMessage: 'Summary / Table view toggle'
    }),
    options: toggleButtons,
    idSelected: toggleSelected,
    onChange: setToggleSelected,
    "data-test-subj": "mlAlertsPanelToggle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }), toggleSelected === 'alertsTable' ? /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable, {
    id: `ml-details-alerts`,
    ruleTypeIds: _common2.ML_RULE_TYPE_IDS,
    consumers: _alerts.ML_VALID_CONSUMERS,
    query: alertsQuery,
    columns: columns,
    sort: sort,
    renderCellValue: _render_cell_value.AlertsTableCellValue,
    renderExpandedAlertView: _alerts_table_flyout.AlertsTableFlyout,
    renderActionsCell: _alert_actions.AlertActions,
    casesConfiguration: {
      appId: _constants.MANAGEMENT_APP_ID,
      featureId: _common.FEATURE_ID,
      owner: [_common.APP_ID],
      syncAlerts: false,
      extractObservables: false
    },
    showAlertStatusWithFlapping: true,
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      licensing,
      settings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_alerts_summary.AlertsSummary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }));
};
exports.AlertsPanel = AlertsPanel;