"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileDataVisualizerPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _wrapper = require("@kbn/file-upload/src/file_upload_component/wrapper");
var _public = require("@kbn/data-visualizer-plugin/public");
var _help_menu = require("../../components/help_menu");
var _kibana = require("../../contexts/kibana");
var _locator = require("../../../../common/constants/locator");
var _license = require("../../license");
var _check_ml_nodes = require("../../ml_nodes_check/check_ml_nodes");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _page_header = require("../../components/page_header");
var _page_title = require("../../components/page_title");
var _util = require("./util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/datavisualizer/file_based/file_datavisualizer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FileDataVisualizerPage = () => {
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const {
    docLinks,
    data: {
      dataViews: {
        get: getDataView
      }
    }
  } = services;
  const mlApi = (0, _kibana.useMlApi)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const mlManagementLocator = (0, _kibana.useMlManagementLocatorInternal)();
  (0, _check_ml_nodes.getMlNodeCount)(mlApi);
  const getDependencies = (0, _react.useCallback)(async () => (0, _util.buildDependencies)(services), [services]);
  const getAdditionalLinks = (0, _react.useMemo)(() => [async ({
    dataViewId,
    globalState
  }) => [{
    id: 'create_ml_job',
    title: _i18n.i18n.translate('xpack.ml.fileDatavisualizer.actionsPanel.anomalyDetectionTitle', {
      defaultMessage: 'Create ML job'
    }),
    description: '',
    icon: 'machineLearningApp',
    type: 'file',
    getUrl: async () => {
      return (await mlManagementLocator.getUrl({
        page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_TYPE,
        pageState: {
          index: dataViewId,
          globalState
        }
      })).url;
    },
    canDisplay: async () => {
      try {
        const {
          timeFieldName
        } = await getDataView(dataViewId);
        return (0, _license.isFullLicense)() && timeFieldName !== undefined && (0, _check_capabilities.checkPermission)('canCreateJob') && (0, _check_ml_nodes.mlNodesAvailable)();
      } catch (error) {
        return false;
      }
    }
  }, {
    id: 'open_in_data_viz',
    title: _i18n.i18n.translate('xpack.ml.fileDatavisualizer.actionsPanel.dataframeTitle', {
      defaultMessage: 'Open in Data Visualizer'
    }),
    description: '',
    icon: 'dataVisualizer',
    type: 'file',
    getUrl: async () => {
      return await mlLocator.getUrl({
        page: _locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER,
        pageState: {
          index: dataViewId,
          globalState
        }
      });
    },
    canDisplay: async () => dataViewId !== ''
  }]],
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mlLocator]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataVisualizer.pageHeader",
      defaultMessage: "Data Visualizer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_wrapper.FileDataVisualizerWrapper, {
    getDependencies: getDependencies,
    location: 'ml-file-data-visualizer',
    getAdditionalLinks: getAdditionalLinks,
    getFieldsStatsGrid: _public.getFieldsStatsGrid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: docLinks.links.ml.guide,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }));
};
exports.FileDataVisualizerPage = FileDataVisualizerPage;