"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassificationDecisionPath = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _d = _interopRequireDefault(require("d3"));
var _use_classification_path_data = require("./use_classification_path_data");
var _decision_path_chart = require("./decision_path_chart");
var _missing_decision_path_callout = require("./missing_decision_path_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/feature_importance/decision_path_classification.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ClassificationDecisionPath = ({
  featureImportance,
  predictedValue,
  topClasses,
  predictionFieldName,
  predictedProbability,
  baseline
}) => {
  const [currentClass, setCurrentClass] = (0, _react.useState)(Array.isArray(topClasses) && topClasses.length > 0 ? (0, _use_classification_path_data.getStringBasedClassName)(topClasses[0].class_name) : '');
  const selectedClass = topClasses.find(t => (0, _use_classification_path_data.getStringBasedClassName)(t.class_name) === (0, _use_classification_path_data.getStringBasedClassName)(currentClass));
  const predictedProbabilityForCurrentClass = selectedClass ? selectedClass.class_probability : undefined;
  const {
    decisionPathData
  } = (0, _use_classification_path_data.useDecisionPathData)({
    baseline,
    featureImportance,
    predictedValue: currentClass,
    predictedProbability: predictedProbabilityForCurrentClass
  });
  const options = (0, _react.useMemo)(() => {
    const predictionValueStr = (0, _use_classification_path_data.getStringBasedClassName)(predictedValue);
    return Array.isArray(topClasses) ? topClasses.map(c => {
      const className = (0, _use_classification_path_data.getStringBasedClassName)(c.class_name);
      return {
        value: className,
        inputDisplay: className === predictionValueStr ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: "success",
          style: {
            lineHeight: 'inherit'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 17
          }
        }, className) : className
      };
    }) : undefined;
  }, [topClasses, predictedValue]);
  const domain = (0, _react.useMemo)(() => {
    let maxDomain;
    let minDomain;
    // if decisionPathData has calculated cumulative path
    if (decisionPathData && (0, _use_classification_path_data.isDecisionPathData)(decisionPathData)) {
      const [min, max] = _d.default.extent(decisionPathData, d => d[2]);
      const buffer = Math.abs(max - min) * 0.1;
      maxDomain = max + buffer;
      minDomain = min - buffer;
    }
    return {
      maxDomain,
      minDomain
    };
  }, [decisionPathData]);
  if (!decisionPathData) return /*#__PURE__*/_react.default.createElement(_missing_decision_path_callout.MissingDecisionPathCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 33
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xxxs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.classificationDecisionPathClassNameTitle', {
    defaultMessage: 'Class name'
  }))), options !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "mlDFADecisionPathClassNameSelect",
    compressed: true,
    options: options,
    valueOfSelected: currentClass,
    onChange: setCurrentClass,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.classificationDecisionPathClassNameTitle', {
      defaultMessage: 'Class name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_decision_path_chart.DecisionPathChart, {
    decisionPathData: decisionPathData,
    predictionFieldName: predictionFieldName,
    minDomain: domain.minDomain,
    maxDomain: domain.maxDomain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }));
};
exports.ClassificationDecisionPath = ClassificationDecisionPath;