"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecisionPathChart = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _kibana = require("../../../../../contexts/kibana");
var _format_value = require("../../../../../formatters/format_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/feature_importance/decision_path_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DECISION_PATH_MARGIN = 125;
const DECISION_PATH_ROW_HEIGHT = 10;
const AnnotationBaselineMarker = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "dot",
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 34
  }
});
const DecisionPathChart = ({
  decisionPathData,
  predictionFieldName,
  minDomain,
  maxDomain,
  baseline
}) => {
  const {
    services: {
      charts: {
        theme: {
          useChartsBaseTheme
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const baseTheme = useChartsBaseTheme();
  const {
    baselineStyle,
    theme
  } = (0, _react.useMemo)(() => {
    const euiColorFullShade = euiTheme.colors.fullShade;
    const euiColorMediumShade = euiTheme.colors.mediumShade;
    const axisColor = euiColorMediumShade;
    const axes = {
      axisLine: {
        stroke: axisColor
      },
      tickLabel: {
        fontSize: 10,
        fill: axisColor
      },
      tickLine: {
        stroke: axisColor
      },
      gridLine: {
        horizontal: {
          dash: [1, 2]
        },
        vertical: {
          strokeWidth: 0
        }
      }
    };
    return {
      baselineStyle: {
        line: {
          strokeWidth: 1,
          stroke: euiColorFullShade,
          opacity: 0.75
        }
      },
      theme: {
        axes,
        lineSeriesStyle: {
          line: {
            visible: true,
            strokeWidth: 1
          },
          point: {
            visible: 'always'
          }
        },
        chartMargins: {
          top: 10
        }
      }
    };
  }, [euiTheme]);
  const regressionBaselineData = (0, _react.useMemo)(() => baseline && (0, _mlDataFrameAnalyticsUtils.isRegressionFeatureImportanceBaseline)(baseline) ? [{
    dataValue: baseline.baseline,
    header: (0, _format_value.formatSingleValue)(baseline.baseline, '').toString(),
    details: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.decisionPathBaselineText', {
      defaultMessage: 'baseline (average of predictions for all data points in the training data set)'
    })
  }] : undefined, [baseline]);
  const xAxisLabel = regressionBaselineData ? _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.decisionPathLinePredictionTitle', {
    defaultMessage: 'Prediction'
  }) : _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.decisionPathLinePredictionProbabilityTitle', {
    defaultMessage: 'Prediction probability'
  });
  // if regression, guarantee up to num_precision significant digits without having it in scientific notation
  // if classification, hide the numeric values since we only want to show the path
  const tickFormatter = (0, _react.useCallback)(d => (0, _format_value.formatSingleValue)(d, '').toString(), []);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDFADecisionPathChart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: DECISION_PATH_MARGIN + decisionPathData.length * DECISION_PATH_ROW_HEIGHT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme,
    baseTheme: baseTheme,
    rotation: 90,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }), regressionBaselineData && /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "xpack.ml.dataframe.analytics.explorationResults.decisionPathBaseline",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: regressionBaselineData,
    style: baselineStyle,
    marker: AnnotationBaselineMarker,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'xpack.ml.dataframe.analytics.explorationResults.decisionPathXAxis',
    tickFormat: tickFormatter,
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.decisionPathXAxisTitle', {
      defaultMessage: "{xAxisLabel} for ''{predictionFieldName}''",
      values: {
        predictionFieldName,
        xAxisLabel
      }
    }),
    gridLine: {
      visible: false
    },
    position: _charts.Position.Top,
    showOverlappingTicks: true,
    domain: minDomain && maxDomain ? {
      min: minDomain,
      max: maxDomain
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    gridLine: {
      visible: true
    },
    id: "left",
    position: _charts.Position.Left,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: 'xpack.ml.dataframe.analytics.explorationResults.decisionPathLine',
    name: xAxisLabel,
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 0,
    yAccessors: [2],
    data: decisionPathData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  })));
};
exports.DecisionPathChart = DecisionPathChart;