"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfluencersList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _i18n = require("@kbn/i18n");
var _entity_cell = require("../entity_cell");
var _influencers_list_styles = require("./influencers_list_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/influencers_list/influencers_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering a list of Machine Learning influencers.
 */
function getTooltipContent(maxScoreLabel, totalScoreLabel) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.influencersList.maxAnomalyScoreTooltipDescription",
    defaultMessage: "Maximum anomaly score: {maxScoreLabel}",
    values: {
      maxScoreLabel
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.influencersList.totalAnomalyScoreTooltipDescription",
    defaultMessage: "Total anomaly score: {totalScoreLabel}",
    values: {
      totalScoreLabel
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  })));
}
const Influencer = ({
  influencerFieldName,
  influencerFilter,
  valueData
}) => {
  const styles = (0, _influencers_list_styles.useInfluencersListStyles)();
  const maxScore = Math.floor(valueData.maxAnomalyScore);
  const maxScoreLabel = (0, _mlAnomalyUtils.getFormattedSeverityScore)(valueData.maxAnomalyScore);
  const severity = (0, _mlAnomalyUtils.getSeverity)(maxScore);
  const totalScoreLabel = (0, _mlAnomalyUtils.getFormattedSeverityScore)(valueData.sumAnomalyScore);

  // Ensure the bar has some width for 0 scores.
  const barScore = maxScore !== 0 ? maxScore : 1;
  const tooltipContent = getTooltipContent(maxScoreLabel, totalScoreLabel);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `mlInfluencerEntry field-${influencerFieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.fieldLabel,
    "data-test-subj": "mlInfluencerEntryFieldLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_entity_cell.EntityCell, {
    entityName: influencerFieldName,
    entityValue: valueData.influencerFieldValue,
    filter: influencerFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: barScore,
    max: 100,
    size: "xs",
    color: styles.progressColor(severity),
    css: styles.progressBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    title: `${influencerFieldName}: ${valueData.influencerFieldValue}`,
    content: tooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: styles.influencerBadgeBackgroundColor(severity),
    css: styles.influencerBadgeTextColor(severity),
    onClick: () => {},
    onClickAriaLabel: _i18n.i18n.translate('xpack.ml.influencersList.badgeClickAreaLabel', {
      defaultMessage: 'Anomaly score details for {influencerFieldName}',
      values: {
        influencerFieldName
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, maxScoreLabel)))));
};
const InfluencersByName = ({
  influencerFieldName,
  influencerFilter,
  fieldValues
}) => {
  const influencerValues = fieldValues.map(valueData => /*#__PURE__*/_react.default.createElement(Influencer, {
    key: valueData.influencerFieldValue,
    influencerFieldName: influencerFieldName,
    influencerFilter: influencerFilter,
    valueData: valueData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: influencerFieldName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": `mlInfluencerFieldName ${influencerFieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, influencerFieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), influencerValues, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }));
};
const InfluencersList = ({
  influencers,
  influencerFilter
}) => {
  const styles = (0, _influencers_list_styles.useInfluencersListStyles)();
  if (influencers === undefined || Object.keys(influencers).length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      css: styles.influencersList,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.influencersList.noInfluencersFoundTitle",
      defaultMessage: "No influencers found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 15
      }
    })))));
  }
  const influencersByName = Object.keys(influencers).map(influencerFieldName => /*#__PURE__*/_react.default.createElement(InfluencersByName, {
    key: influencerFieldName,
    influencerFieldName: influencerFieldName,
    influencerFilter: influencerFilter,
    fieldValues: influencers[influencerFieldName],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.influencersList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 10
    }
  }, influencersByName);
};
exports.InfluencersList = InfluencersList;