"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _i18n = require("@kbn/i18n");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlParseInterval = require("@kbn/ml-parse-interval");
var _locator = require("../../../common/constants/locator");
var _job_selector = require("../job_selector");
var _jobs = require("../../application/services/ml_api_service/jobs");
var _http_service = require("../../application/services/http_service");
var _toast_notification_service = require("../../application/services/toast_notification_service");
var _severity_control = require("../../application/components/severity_control");
var _result_type_selector = require("./result_type_selector");
var _alerting = require("../../application/services/ml_api_service/alerting");
var _preview_alert_condition = require("./preview_alert_condition");
var _interim_results_control = require("./interim_results_control");
var _config_validator = require("./config_validator");
var _advanced_settings = require("./advanced_settings");
var _alerts = require("../../../common/util/alerts");
var _anomaly_kql_filter = require("./anomaly_kql_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_rule/ml_anomaly_alert_trigger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MlAnomalyAlertTrigger = ({
  ruleParams,
  setRuleParams,
  setRuleProperty,
  errors,
  ruleInterval,
  alertNotifyWhen,
  getStartServices,
  mlCapabilities
}) => {
  var _ruleParams$jobSelect2, _ruleParams$jobSelect3;
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const [newJobUrl, setNewJobUrl] = (0, _react.useState)(undefined);
  const [savedFilterForNonBucketTypes, setSavedFilterForNonBucketTypes] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    let mounted = true;
    if (!mlCapabilities.canCreateJob) return;
    getStartServices().then(startServices => {
      const {
        managementLocator
      } = startServices[2];
      if (!managementLocator) return;
      managementLocator.getUrl({
        page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB
      }, 'anomaly_detection').then(({
        url
      }) => {
        if (mounted) {
          setNewJobUrl(url);
        }
      });
    });
    return () => {
      mounted = false;
    };
  }, [mlCapabilities, getStartServices]);
  const mlHttpService = (0, _react.useMemo)(() => new _http_service.HttpService(http), [http]);
  const adJobsApiService = (0, _react.useMemo)(() => (0, _jobs.jobsApiProvider)(mlHttpService), [mlHttpService]);
  const alertingApiService = (0, _react.useMemo)(() => (0, _alerting.alertingApiProvider)(mlHttpService), [mlHttpService]);
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [jobConfigs, setJobConfigs] = (0, _react.useState)([]);
  const onAlertParamChange = (0, _react.useCallback)(param => update => {
    setRuleParams(param, update);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const jobsAndGroupIds = (0, _react.useMemo)(() => {
    var _ruleParams$jobSelect;
    return Object.values((_ruleParams$jobSelect = ruleParams.jobSelection) !== null && _ruleParams$jobSelect !== void 0 ? _ruleParams$jobSelect : {}).flat();
  }, [ruleParams.jobSelection]);

  /**
   * Extract alert related information based on the job selection
   */
  const fetchJobsConfig = (0, _react.useCallback)(async () => {
    try {
      const jobs = await adJobsApiService.jobs(jobsAndGroupIds);
      setJobConfigs(jobs);
    } catch (e) {
      displayErrorToast(e, _i18n.i18n.translate('xpack.ml.anomalyDetectionAlert.errorFetchingJobs', {
        defaultMessage: 'Unable to fetch jobs configuration'
      }), 5000);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobsAndGroupIds]);
  const availableResultTypes = (0, _react.useMemo)(() => {
    if (jobConfigs.length === 0) return Object.values(_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE);
    return (jobConfigs !== null && jobConfigs !== void 0 ? jobConfigs : []).some(v => {
      var _v$analysis_config, _v$analysis_config$in;
      return Boolean((_v$analysis_config = v.analysis_config) === null || _v$analysis_config === void 0 ? void 0 : (_v$analysis_config$in = _v$analysis_config.influencers) === null || _v$analysis_config$in === void 0 ? void 0 : _v$analysis_config$in.length);
    }) ? Object.values(_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE) : [_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET, _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.RECORD];
  }, [jobConfigs]);
  (0, _react.useEffect)(function checkJobsConfiguration() {
    if (jobsAndGroupIds.length === 0) return;
    fetchJobsConfig();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobsAndGroupIds]);
  (0, _react.useEffect)(function handleFilterPreservationAcrossResultTypes() {
    const isBucketType = ruleParams.resultType === _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET;
    if (isBucketType) {
      if (ruleParams.kqlQueryString) {
        setSavedFilterForNonBucketTypes(ruleParams.kqlQueryString);
        setRuleParams('kqlQueryString', null);
      }
    } else {
      if (savedFilterForNonBucketTypes && !ruleParams.kqlQueryString) {
        setRuleParams('kqlQueryString', savedFilterForNonBucketTypes);
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [ruleParams.resultType]);
  (0, _useMount.default)(function setDefaults() {
    const {
      jobSelection,
      ...rest
    } = ruleParams;
    if (Object.keys(rest).length === 0) {
      setRuleProperty('params', {
        // Set defaults
        severity: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL,
        resultType: _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET,
        includeInterim: false,
        // Preserve job selection
        jobSelection,
        lookbackInterval: undefined,
        topNBuckets: undefined
      });
    }
  });
  const advancedSettings = (0, _react.useMemo)(() => {
    let {
      lookbackInterval,
      topNBuckets
    } = ruleParams;
    if (!(0, _mlIsDefined.isDefined)(lookbackInterval) && jobConfigs.length > 0) {
      lookbackInterval = (0, _alerts.getLookbackInterval)(jobConfigs);
    }
    if (!(0, _mlIsDefined.isDefined)(topNBuckets) && jobConfigs.length > 0) {
      topNBuckets = (0, _alerts.getTopNBuckets)(jobConfigs[0]);
    }
    return {
      lookbackInterval,
      topNBuckets
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ruleParams.lookbackInterval, ruleParams.topNBuckets, jobConfigs]);
  const resultParams = (0, _react.useMemo)(() => {
    return {
      ...ruleParams,
      ...advancedSettings
    };
  }, [ruleParams, advancedSettings]);
  const maxNumberOfBuckets = (0, _react.useMemo)(() => {
    if (jobConfigs.length === 0) return;
    const bucketDuration = (0, _mlParseInterval.parseInterval)(jobConfigs[0].analysis_config.bucket_span);
    const lookbackIntervalDuration = advancedSettings.lookbackInterval ? (0, _mlParseInterval.parseInterval)(advancedSettings.lookbackInterval) : null;
    if (lookbackIntervalDuration && bucketDuration) {
      return Math.ceil(lookbackIntervalDuration.asSeconds() / bucketDuration.asSeconds());
    }
  }, [jobConfigs, advancedSettings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": 'mlAnomalyAlertForm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_job_selector.JobSelectorControl, {
    createJobUrl: newJobUrl,
    jobsAndGroupIds: jobsAndGroupIds,
    adJobsApiService: adJobsApiService,
    onChange: onAlertParamChange('jobSelection'),
    errors: Array.isArray(errors.jobSelection) ? errors.jobSelection : [],
    shouldUseDropdownJobCreate: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_config_validator.ConfigValidator, {
    jobConfigs: jobConfigs,
    alertInterval: ruleInterval,
    alertNotifyWhen: alertNotifyWhen,
    alertParams: resultParams,
    maxNumberOfBuckets: maxNumberOfBuckets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_result_type_selector.ResultTypeSelector, {
    value: ruleParams.resultType,
    availableOption: availableResultTypes,
    onChange: onAlertParamChange('resultType'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_severity_control.SeverityControl, {
    value: ruleParams.severity,
    onChange: onAlertParamChange('severity'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_anomaly_kql_filter.AnomalyKqlFilter, {
    value: ruleParams.kqlQueryString,
    onChange: onAlertParamChange('kqlQueryString'),
    jobConfigs: jobConfigs,
    resultType: ruleParams.resultType,
    jobId: (_ruleParams$jobSelect2 = ruleParams.jobSelection) === null || _ruleParams$jobSelect2 === void 0 ? void 0 : (_ruleParams$jobSelect3 = _ruleParams$jobSelect2.jobIds) === null || _ruleParams$jobSelect3 === void 0 ? void 0 : _ruleParams$jobSelect3[0],
    errors: Array.isArray(errors.kqlQueryString) ? errors.kqlQueryString : [],
    disabled: ruleParams.resultType === _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_interim_results_control.InterimResultsControl, {
    value: ruleParams.includeInterim,
    onChange: onAlertParamChange('includeInterim'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_settings.AdvancedSettings, {
    value: advancedSettings,
    onChange: (0, _react.useCallback)(update => {
      Object.keys(update).forEach(k => {
        setRuleParams(k, update[k]);
      });
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_preview_alert_condition.PreviewAlertCondition, {
    alertingApiService: alertingApiService,
    alertParams: ruleParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }));
};

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = exports.default = MlAnomalyAlertTrigger;
module.exports = exports.default;