"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyKqlFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _index_patterns = require("../../../common/constants/index_patterns");
var _get_relevant_anomaly_fields = require("./get_relevant_anomaly_fields");
var _kibana = require("../../application/contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_rule/anomaly_kql_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyKqlFilter = exports.AnomalyKqlFilter = /*#__PURE__*/_react.default.memo(({
  value,
  onChange,
  jobConfigs,
  resultType,
  jobId,
  errors,
  disabled
}) => {
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const {
    unifiedSearch,
    data
  } = services;
  const dataViewsService = data === null || data === void 0 ? void 0 : data.dataViews;
  const [mlAnomaliesDataView, setMlAnomaliesDataView] = (0, _react.useState)();
  const relevantFields = (0, _react.useMemo)(() => (0, _get_relevant_anomaly_fields.getRelevantAnomalyFields)(jobConfigs, resultType), [jobConfigs, resultType]);

  // Create filter for autocomplete suggestions - only show values from current job
  const filtersForSuggestions = (0, _react.useMemo)(() => {
    if (!jobId) return [];
    return [{
      meta: {
        disabled: false,
        negate: false,
        alias: null,
        key: 'job_id'
      },
      query: {
        match_phrase: {
          job_id: jobId
        }
      }
    }];
  }, [jobId]);
  (0, _react.useEffect)(function fetchAndCreateDataView() {
    if (!dataViewsService || disabled) return;
    let isMounted = true;
    let createdDataView;
    const fetchDataView = async () => {
      try {
        const allFields = await dataViewsService.getFieldsForWildcard({
          pattern: _index_patterns.ML_RESULTS_INDEX_PATTERN
        });
        const filteredFields = relevantFields.length > 0 ? allFields.filter(field => relevantFields.includes(field.name)) : allFields;
        const fieldsMap = filteredFields.reduce((acc, field) => {
          acc[field.name] = field;
          return acc;
        }, {});
        const dataView = await dataViewsService.create({
          title: _index_patterns.ML_RESULTS_INDEX_PATTERN,
          fields: fieldsMap
        }, true);
        createdDataView = dataView;
        if (isMounted) {
          setMlAnomaliesDataView(dataView);
        }
      } catch (error) {
        // eslint-disable-next-line no-console
        console.error('Failed to fetch/create ML anomalies data view:', error);
      }
    };
    fetchDataView();
    return () => {
      var _createdDataView;
      isMounted = false;
      if ((_createdDataView = createdDataView) !== null && _createdDataView !== void 0 && _createdDataView.id) {
        dataViewsService.clearInstanceCache(createdDataView.id);
      }
    };
  }, [dataViewsService, relevantFields, disabled]);

  /**
   * Handle KQL query changes
   * Note: Validation is handled by the parent form validation in register_anomaly_detection_rule.tsx
   * This avoids parsing the KQL twice (once here, once in validation)
   */
  const handleKqlChange = (0, _react.useCallback)(payload => {
    var _ref, _payload$query;
    const kqlText = (_ref = (_payload$query = payload.query) === null || _payload$query === void 0 ? void 0 : _payload$query.query) !== null && _ref !== void 0 ? _ref : '';
    onChange(kqlText.trim() || null);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.anomalyFilterLabel",
      defaultMessage: "Anomaly filter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }),
    helpText: disabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.anomalyFilterDisabledDescription",
      defaultMessage: "Filter is not available for bucket result type.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.anomalyFilterDescription",
      defaultMessage: "Use a KQL expression to limit which anomalies trigger alerts.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 13
      }
    }),
    "data-test-subj": "mlAnomalyAlertKqlFilterFormRow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }), unifiedSearch ? /*#__PURE__*/_react.default.createElement(unifiedSearch.ui.SearchBar, {
    appName: "ML",
    iconType: "search",
    placeholder: _i18n.i18n.translate('xpack.ml.anomalyDetectionAlert.kqlFilter.placeholder', {
      defaultMessage: 'Filter anomalies using KQL syntax'
    }),
    indexPatterns: mlAnomaliesDataView ? [mlAnomaliesDataView] : undefined,
    filtersForSuggestions: filtersForSuggestions,
    showQueryInput: true,
    showQueryMenu: false,
    showFilterBar: false,
    showDatePicker: false,
    showSubmitButton: false,
    displayStyle: "inPage",
    onQueryChange: handleKqlChange,
    onQuerySubmit: handleKqlChange,
    query: {
      query: value !== null && value !== void 0 ? value : '',
      language: 'kuery'
    },
    dataTestSubj: "mlAnomalyAlertKqlSearchBar",
    submitOnBlur: true,
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    size: "m",
    contentAriaLabel: _i18n.i18n.translate('xpack.ml.anomalyDetectionAlert.kqlFilter.loadingAriaLabel', {
      defaultMessage: 'Loading KQL filter input'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }), errors && errors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.ml.anomalyDetectionAlert.kqlFilter.errorTitle', {
      defaultMessage: 'Invalid KQL query'
    }),
    color: "danger",
    iconType: "alert",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }, errors.map((error, index) => /*#__PURE__*/_react.default.createElement("p", {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }, error))))));
});
AnomalyKqlFilter.displayName = 'AnomalyKqlFilter';