"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.labelZoomRangeSchema = exports.labelStaticOptions = exports.labelSchema = exports.labelPositionSchema = exports.labelDynamicOptions = exports.labelBorderSizeSchema = exports.labelBorderSizeOptions = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../../../common/constants");
var _style_field_schema = require("./style_field_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const labelBorderSizeOptions = exports.labelBorderSizeOptions = _configSchema.schema.object({
  size: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.LABEL_BORDER_SIZES.NONE), _configSchema.schema.literal(_constants.LABEL_BORDER_SIZES.SMALL), _configSchema.schema.literal(_constants.LABEL_BORDER_SIZES.MEDIUM), _configSchema.schema.literal(_constants.LABEL_BORDER_SIZES.LARGE)])
});
const labelBorderSizeSchema = exports.labelBorderSizeSchema = _configSchema.schema.object({
  options: labelBorderSizeOptions
}, {
  defaultValue: {
    options: {
      size: _constants.LABEL_BORDER_SIZES.SMALL
    }
  },
  meta: {
    description: 'Configure to set label border width'
  }
});
const labelPositionSchema = exports.labelPositionSchema = _configSchema.schema.object({
  options: _configSchema.schema.object({
    position: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.LABEL_POSITIONS.BOTTOM), _configSchema.schema.literal(_constants.LABEL_POSITIONS.CENTER), _configSchema.schema.literal(_constants.LABEL_POSITIONS.TOP)])
  })
}, {
  defaultValue: {
    options: {
      position: _constants.LABEL_POSITIONS.CENTER
    }
  },
  meta: {
    description: 'Configure to place label above, in the center of, or below the Point feature'
  }
});
const labelZoomRangeSchema = exports.labelZoomRangeSchema = _configSchema.schema.object({
  options: _configSchema.schema.object({
    useLayerZoomRange: _configSchema.schema.boolean(),
    minZoom: _configSchema.schema.number(),
    maxZoom: _configSchema.schema.number()
  })
}, {
  defaultValue: {
    options: {
      useLayerZoomRange: true,
      minZoom: _constants.MIN_ZOOM,
      maxZoom: _constants.MAX_ZOOM
    }
  },
  meta: {
    description: 'Configure to set the zoom range for which labels are displayed'
  }
});
const labelDynamicOptions = exports.labelDynamicOptions = _configSchema.schema.object({
  field: _configSchema.schema.maybe(_style_field_schema.styleFieldSchema)
});
const labelStaticOptions = exports.labelStaticOptions = _configSchema.schema.object({
  value: _configSchema.schema.string({
    meta: {
      description: 'Provided value displayed as feature label'
    }
  })
});
const labelSchema = exports.labelSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.STATIC),
  options: labelStaticOptions
}), _configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.DYNAMIC),
  options: labelDynamicOptions
})], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      value: ''
    }
  },
  meta: {
    description: 'Configure to set label content'
  }
});