"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = exports.searchOptionsSchema = exports.mapsUpdateOptionsSchema = exports.mapsSearchOptionsSchema = exports.mapsGetResultSchema = exports.mapsCreateResultSchema = exports.mapsCreateOptionsSchema = exports.mapSavedObjectSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _map_attributes_schema = require("./map_attributes_schema/map_attributes_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapSavedObjectSchema = exports.mapSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(_map_attributes_schema.mapAttributesSchema);
const searchOptionsSchema = exports.searchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const mapsSearchOptionsSchema = exports.mapsSearchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const mapsCreateOptionsSchema = exports.mapsCreateOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  references: _configSchema.schema.maybe(_contentManagementUtils.referencesSchema)
}));
const mapsUpdateOptionsSchema = exports.mapsUpdateOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  references: _configSchema.schema.maybe(_contentManagementUtils.referencesSchema)
}));
const mapsGetResultSchema = exports.mapsGetResultSchema = (0, _contentManagementUtils.objectTypeToGetResultSchema)(mapSavedObjectSchema);
const mapsCreateResultSchema = exports.mapsCreateResultSchema = (0, _contentManagementUtils.createResultSchema)(mapSavedObjectSchema);

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(mapSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: mapsCreateOptionsSchema
      },
      data: {
        schema: _map_attributes_schema.mapAttributesSchema
      }
    },
    out: {
      result: {
        schema: mapsCreateResultSchema
      }
    }
  },
  update: {
    in: {
      options: {
        schema: mapsUpdateOptionsSchema
      },
      data: {
        schema: _map_attributes_schema.mapAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: searchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: mapSavedObjectSchema
      }
    }
  }
};