"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialRefreshConfig = getInitialRefreshConfig;
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInitialRefreshConfig({
  mapState,
  globalState = {}
}) {
  const uiSettings = (0, _kibana_services.getUiSettings)();
  if (mapState !== null && mapState !== void 0 && mapState.refreshInterval) {
    return mapState.refreshInterval;
  }
  const defaultRefreshConfig = uiSettings.get(_public.UI_SETTINGS.TIMEPICKER_REFRESH_INTERVAL_DEFAULTS);
  return {
    ...defaultRefreshConfig,
    ...globalState.refreshInterval
  };
}