"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewVectorLayerEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_new_index_pattern = require("./create_new_index_pattern");
var _es_documents_layer_wizard = require("../../../sources/es_search_source/es_documents_layer_wizard");
var _view = require("../../../../connected_components/add_layer_panel/view");
var _kibana_services = require("../../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/new_vector_layer_wizard/wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_MAPPINGS = {
  created: {
    properties: {
      '@timestamp': {
        type: 'date'
      },
      user: {
        type: 'keyword'
      }
    }
  }
};
class NewVectorLayerEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      indexName: '',
      indexNameError: '',
      indexingTriggered: false,
      createIndexError: '',
      userHasIndexWritePermissions: true
    });
    (0, _defineProperty2.default)(this, "_createNewIndex", async () => {
      let indexPatternId;
      try {
        const userHasIndexWritePermissions = await this._checkIndexPermissions();
        if (!userHasIndexWritePermissions) {
          this._setCreateIndexError(_i18n.i18n.translate('xpack.maps.layers.newVectorLayerWizard.indexPermissionsError', {
            defaultMessage: `You must have 'create' and 'create_index' index privileges to create and write data to "{indexName}".`,
            values: {
              indexName: this.state.indexName
            }
          }), userHasIndexWritePermissions);
          return;
        }
        const response = await (0, _create_new_index_pattern.createNewIndexAndPattern)({
          indexName: this.state.indexName,
          defaultMappings: DEFAULT_MAPPINGS
        });
        indexPatternId = response.indexPatternId;
      } catch (e) {
        this._setCreateIndexError(e.message);
        return;
      }
      if (!indexPatternId) {
        this._setCreateIndexError(_i18n.i18n.translate('xpack.maps.layers.newVectorLayerWizard.createIndexError', {
          defaultMessage: 'Could not create index with name {message}',
          values: {
            message: this.state.indexName
          }
        }));
        return;
      }
      if (!this._isMounted) {
        return;
      }
      // Creates empty layer
      const layerDescriptor = (0, _es_documents_layer_wizard.createDefaultLayerDescriptor)({
        indexPatternId,
        geoField: 'coordinates',
        filterByMapBounds: false,
        applyGlobalQuery: false
      }, this.props.mapColors);
      this.props.previewLayers([layerDescriptor]);
      this.props.advanceToNextStep();
    });
    (0, _defineProperty2.default)(this, "_onIndexChange", (indexName, indexError) => {
      this.setState({
        indexName,
        indexNameError: indexError ? indexError : ''
      });
      if (indexName && !indexError) {
        this.props.enableNextBtn();
      } else {
        this.props.disableNextBtn();
      }
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async componentDidUpdate() {
    if (this.props.currentStepId === _view.ADD_LAYER_STEP_ID && !this.state.indexingTriggered) {
      this.setState({
        indexingTriggered: true
      });
      await this._createNewIndex();
    }
  }
  _setCreateIndexError(errorMessage, userHasIndexWritePermissions = true) {
    if (!this._isMounted) {
      return;
    }
    this.setState({
      createIndexError: errorMessage,
      userHasIndexWritePermissions
    });
  }
  async _checkIndexPermissions() {
    return await (0, _kibana_services.getFileUpload)().hasImportPermission({
      checkCreateDataView: true,
      checkHasManagePipeline: false,
      indexName: this.state.indexName
    });
  }
  render() {
    if (this.state.createIndexError) {
      if (!this.state.userHasIndexWritePermissions) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          announceOnMount: true,
          title: _i18n.i18n.translate('xpack.maps.layers.newVectorLayerWizard.indexPrivsErrorTitle', {
            defaultMessage: 'Missing index privileges'
          }),
          color: "danger",
          iconType: "warning",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 153,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 161,
            columnNumber: 13
          }
        }, this.state.createIndexError));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        announceOnMount: true,
        title: _i18n.i18n.translate('xpack.maps.layers.newVectorLayerWizard.createIndexErrorTitle', {
          defaultMessage: 'Unable to create index'
        }),
        color: "danger",
        iconType: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 11
        }
      }, this.state.createIndexError));
    }
    const IndexNameForm = (0, _kibana_services.getIndexNameFormComponent)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(IndexNameForm, {
      indexName: this.state.indexName,
      indexNameError: this.state.indexNameError,
      onIndexNameChange: this._onIndexChange,
      onIndexNameValidationStart: () => {},
      onIndexNameValidationEnd: () => {},
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }));
  }
}
exports.NewVectorLayerEditor = NewVectorLayerEditor;