"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _esqlUtils = require("@kbn/esql-utils");
var _field = require("./field");
var _kibana_services = require("../../kibana_services");
var _tooltip_property = require("../tooltips/tooltip_property");
var _es_tooltip_property = require("../tooltips/es_tooltip_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ESQLField extends _field.AbstractField {
  constructor({
    fieldName,
    source,
    origin
  }) {
    super({
      fieldName,
      origin
    });
    (0, _defineProperty2.default)(this, "_source", void 0);
    this._source = source;
  }
  supportsFieldMetaFromEs() {
    return false;
  }
  supportsFieldMetaFromLocalData() {
    return true;
  }
  getSource() {
    return this._source;
  }
  async getDataType() {
    var _getFieldType;
    const columns = await (0, _esqlUtils.getESQLQueryColumnsRaw)({
      esqlQuery: this._source.getESQL(),
      search: (0, _kibana_services.getData)().search.search,
      timeRange: (0, _kibana_services.getData)().query.timefilter.timefilter.getAbsoluteTime()
    });
    const column = columns.find(({
      name
    }) => name === this.getName());
    return (_getFieldType = getFieldType(column)) !== null && _getFieldType !== void 0 ? _getFieldType : 'string';
  }
  async createTooltipProperty(value) {
    var _dataView;
    let dataView;
    try {
      dataView = await this._source.getIndexPattern();
    } catch (e) {
      // fall back to displaying raw feature properties in tooltip
      // when unable to create adhoc data view
    }
    const tooltipProperty = new _tooltip_property.TooltipProperty(this.getName(), this.getName(), value);
    return ((_dataView = dataView) === null || _dataView === void 0 ? void 0 : _dataView.getFieldByName(this.getName())) !== undefined ? new _es_tooltip_property.ESTooltipProperty(tooltipProperty, dataView, this, this._source.getApplyGlobalQuery()) : tooltipProperty;
  }
}

/*
 * Map column.type to field type
 * Supported column types https://www.elastic.co/guide/en/elasticsearch/reference/master/esql-limitations.html#_supported_types
 */
exports.ESQLField = ESQLField;
function getFieldType(column) {
  if (!column) return undefined;
  switch (column.type) {
    case 'boolean':
    case 'date':
    case 'ip':
    case 'keyword':
    case 'text':
      return 'string';
    case 'double':
    case 'int':
    case 'long':
    case 'unsigned_long':
      return 'number';
    default:
      return undefined;
  }
}