"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _create_maintenance_window_route = require("./apis/maintenance_window/internal/create/create_maintenance_window_route");
var _get_maintenance_window_route = require("./apis/maintenance_window/internal/get/get_maintenance_window_route");
var _update_maintenance_window_route = require("./apis/maintenance_window/internal/update/update_maintenance_window_route");
var _delete_maintenance_window_route = require("./apis/maintenance_window/internal/delete/delete_maintenance_window_route");
var _find_maintenance_windows_route = require("./apis/maintenance_window/internal/find/find_maintenance_windows_route");
var _archive_maintenance_window_route = require("./apis/maintenance_window/internal/archive/archive_maintenance_window_route");
var _finish_maintenance_window_route = require("./apis/maintenance_window/internal/finish/finish_maintenance_window_route");
var _get_active_maintenance_windows_route = require("./apis/maintenance_window/internal/get_active/get_active_maintenance_windows_route");
var _bulk_get_maintenance_windows_route = require("./apis/maintenance_window/internal/bulk_get/bulk_get_maintenance_windows_route");
var _get_maintenance_window_route2 = require("./apis/maintenance_window/external/get/get_maintenance_window_route");
var _create_maintenance_window_route2 = require("./apis/maintenance_window/external/create/create_maintenance_window_route");
var _delete_maintenance_window_route2 = require("./apis/maintenance_window/external/delete/delete_maintenance_window_route");
var _archive_maintenance_window_route2 = require("./apis/maintenance_window/external/archive/archive_maintenance_window_route");
var _unarchive_maintenance_window_route = require("./apis/maintenance_window/external/unarchive/unarchive_maintenance_window_route");
var _update_maintenance_window_route2 = require("./apis/maintenance_window/external/update/update_maintenance_window_route");
var _find_maintenance_windows_route2 = require("./apis/maintenance_window/external/find/find_maintenance_windows_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRoutes(opts) {
  const {
    router,
    licenseState,
    maintenanceWindowsConfig
  } = opts;
  if (maintenanceWindowsConfig.enabled) {
    // Internal APIs
    (0, _create_maintenance_window_route.createMaintenanceWindowRoute)(router, licenseState);
    (0, _get_maintenance_window_route.getMaintenanceWindowRoute)(router, licenseState);
    (0, _update_maintenance_window_route.updateMaintenanceWindowRoute)(router, licenseState);
    (0, _delete_maintenance_window_route.deleteMaintenanceWindowRoute)(router, licenseState);
    (0, _find_maintenance_windows_route.findMaintenanceWindowsRoute)(router, licenseState);
    (0, _archive_maintenance_window_route.archiveMaintenanceWindowRoute)(router, licenseState);
    (0, _finish_maintenance_window_route.finishMaintenanceWindowRoute)(router, licenseState);
    (0, _get_active_maintenance_windows_route.getActiveMaintenanceWindowsRoute)(router, licenseState);
    (0, _bulk_get_maintenance_windows_route.bulkGetMaintenanceWindowRoute)(router, licenseState);

    // External APIs
    (0, _get_maintenance_window_route2.getMaintenanceWindowRoute)(router, licenseState);
    (0, _create_maintenance_window_route2.createMaintenanceWindowRoute)(router, licenseState);
    (0, _delete_maintenance_window_route2.deleteMaintenanceWindowRoute)(router, licenseState);
    (0, _archive_maintenance_window_route2.archiveMaintenanceWindowRoute)(router, licenseState);
    (0, _unarchive_maintenance_window_route.unarchiveMaintenanceWindowRoute)(router, licenseState);
    (0, _update_maintenance_window_route2.updateMaintenanceWindowRoute)(router, licenseState);
    (0, _find_maintenance_windows_route2.findMaintenanceWindowsRoute)(router, licenseState);
  }
}