"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformCreateBody = void 0;
var _schedule = require("../../../../../schemas/schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *  This function converts from the external, human readable, Maintenance Window creation/POST
 *  type expected by the public APIs, to the internal type used by the client.
 */
const transformCreateBody = createBody => {
  var _createBody$scope;
  const {
    rRule,
    duration
  } = (0, _schedule.transformCustomScheduleToRRule)(createBody.schedule.custom);
  const kql = (_createBody$scope = createBody.scope) === null || _createBody$scope === void 0 ? void 0 : _createBody$scope.alerting.query.kql;
  return {
    title: createBody.title,
    enabled: createBody.enabled,
    ...(kql && {
      scopedQuery: {
        kql,
        filters: []
      }
    }),
    duration,
    rRule
  };
};
exports.transformCreateBody = transformCreateBody;