"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowClientFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _client = require("./client");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MaintenanceWindowClientFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "isInitialized", false);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsService", void 0);
    (0, _defineProperty2.default)(this, "securityService", void 0);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
  }
  initialize(options) {
    if (this.isInitialized) {
      throw new Error('MaintenanceWindowClientFactory already initialized');
    }
    this.isInitialized = true;
    this.logger = options.logger;
    this.savedObjectsService = options.savedObjectsService;
    this.securityService = options.securityService;
    this.uiSettings = options.uiSettings;
  }
  createMaintenanceWindowClient(request, withAuth) {
    const {
      securityService
    } = this;
    const savedObjectsClient = this.savedObjectsService.getScopedClient(request, {
      includedHiddenTypes: [_common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE],
      ...(withAuth ? {} : {
        excludedExtensions: [_server.SECURITY_EXTENSION_ID]
      })
    });
    const uiSettingClient = this.uiSettings.asScopedToClient(savedObjectsClient);
    return new _client.MaintenanceWindowClient({
      logger: this.logger,
      savedObjectsClient,
      uiSettings: uiSettingClient,
      async getUserName() {
        var _user$username;
        const user = securityService.authc.getCurrentUser(request);
        return (_user$username = user === null || user === void 0 ? void 0 : user.username) !== null && _user$username !== void 0 ? _user$username : null;
      }
    });
  }
  createWithAuthorization(request) {
    return this.createMaintenanceWindowClient(request, true);
  }
  create(request) {
    return this.createMaintenanceWindowClient(request, false);
  }
}
exports.MaintenanceWindowClientFactory = MaintenanceWindowClientFactory;