"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStateManagementForInlineEditing = getStateManagementForInlineEditing;
var _shared_logic = require("../../state_management/shared_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getStateManagementForInlineEditing(activeDatasourceId, getAttributes, updateAttributes, visualizationMap, datasourceMap, extractFilterReferences) {
  const updatePanelState = (datasourceState, visualizationState, visualizationType) => {
    var _newViz$visualization;
    const viz = getAttributes();
    const datasourceStates = {
      [activeDatasourceId]: {
        isLoading: false,
        state: datasourceState
      }
    };
    const newViz = (0, _shared_logic.mergeToNewDoc)(viz, {
      activeId: visualizationType || viz.visualizationType,
      state: visualizationState,
      selectedLayerId: null
    }, datasourceStates, viz.state.query, viz.state.filters, activeDatasourceId, viz.state.adHocDataViews || {}, {
      visualizationMap,
      datasourceMap,
      extractFilterReferences
    });
    const newDoc = {
      ...viz,
      ...newViz,
      visualizationType: (_newViz$visualization = newViz === null || newViz === void 0 ? void 0 : newViz.visualizationType) !== null && _newViz$visualization !== void 0 ? _newViz$visualization : viz.visualizationType
    };
    if (newDoc.state) {
      updateAttributes(newDoc, true);
    }
  };
  const updateSuggestion = updateAttributes;
  return {
    updateSuggestion,
    updatePanelState
  };
}