"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensAttributeService = getLensAttributeService;
exports.savedObjectToEmbeddableAttributes = void 0;
var _lodash = require("lodash");
var _persistence = require("./persistence");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savedObjectToEmbeddableAttributes = savedObject => {
  var _savedObject$attribut;
  return {
    ...savedObject.attributes,
    visualizationType: (_savedObject$attribut = savedObject.attributes.visualizationType) !== null && _savedObject$attribut !== void 0 ? _savedObject$attribut : null,
    state: savedObject.attributes.state,
    references: savedObject.references
  };
};
exports.savedObjectToEmbeddableAttributes = savedObjectToEmbeddableAttributes;
function getLensAttributeService(http) {
  const lensDocumentService = new _persistence.LensDocumentService(http);
  return {
    loadFromLibrary: async savedObjectId => {
      const {
        item,
        meta
      } = await lensDocumentService.load(savedObjectId);
      return {
        attributes: {
          ...item,
          state: item.state
        },
        sharingSavedObjectProps: {
          aliasTargetId: meta.aliasTargetId,
          outcome: meta.outcome,
          aliasPurpose: meta.aliasPurpose,
          sourceId: item.id
        },
        managed: Boolean(meta.managed)
      };
    },
    saveToLibrary: async (attributes, references, savedObjectId) => {
      const result = await lensDocumentService.save({
        ...attributes,
        state: attributes.state,
        references,
        savedObjectId
      });
      return result.savedObjectId;
    },
    checkForDuplicateTitle: async ({
      newTitle,
      isTitleDuplicateConfirmed,
      onTitleDuplicate = _lodash.noop,
      displayName = _constants.DOC_TYPE,
      lastSavedTitle = '',
      copyOnSave = false,
      id
    }) => {
      return {
        isDuplicate: await lensDocumentService.checkForDuplicateTitle({
          id,
          title: newTitle,
          isTitleDuplicateConfirmed,
          displayName,
          lastSavedTitle,
          copyOnSave
        }, onTitleDuplicate)
      };
    }
  };
}