"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorFrameServiceProvider = EditorFrameServiceProvider;
exports.useEditorFrameService = useEditorFrameService;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame_service_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditorFrameServiceContext = /*#__PURE__*/(0, _react.createContext)(undefined);
/**
 * Provider component that makes visualizationMap and datasourceMap available
 * throughout the component tree via React context.
 *
 * This provides the same values returned by plugin.initEditorFrameService().
 *
 * This should be added at the root of:
 * - Full-page Lens editor
 * - Inline edit configuration flyout
 * - Embeddable component
 */
function EditorFrameServiceProvider({
  visualizationMap,
  datasourceMap,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(EditorFrameServiceContext.Provider, {
    value: {
      visualizationMap,
      datasourceMap
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, children);
}

/**
 * Hook to access visualizationMap and datasourceMap from context.
 *
 * Returns the same values as plugin.initEditorFrameService().
 *
 * @throws Error if used outside of EditorFrameServiceProvider
 *
 * @example
 * ```tsx
 * function MyComponent() {
 *   const { visualizationMap, datasourceMap } = useEditorFrameService();
 *   const activeViz = visualizationMap[activeId];
 *   // ...
 * }
 * ```
 */
function useEditorFrameService() {
  const context = (0, _react.useContext)(EditorFrameServiceContext);
  if (!context) {
    throw new Error('useEditorFrameService must be used within an EditorFrameServiceProvider');
  }
  return context;
}