"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rangeOperation = exports.isValidRange = exports.isRangeWithin = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/expressions-plugin/public");
var _range_editor = require("./range_editor");
var _layer_helpers = require("../../layer_helpers");
var _supported_formats = require("../../../../../../common/expressions/defs/format_column/supported_formats");
var _constants = require("./constants");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/ranges/ranges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const isRangeWithin = range => range.from <= range.to;
exports.isRangeWithin = isRangeWithin;
const isFullRange = range => (0, _helpers.isValidNumber)(range.from) && (0, _helpers.isValidNumber)(range.to);
const isValidRange = range => {
  if (isFullRange(range)) {
    return isRangeWithin(range);
  }
  return true;
};
exports.isValidRange = isValidRange;
function getFieldDefaultFormat(indexPattern, field) {
  if (field) {
    if (indexPattern.fieldFormatMap && indexPattern.fieldFormatMap[field.name]) {
      return indexPattern.fieldFormatMap[field.name];
    }
  }
  return undefined;
}
const rangeOperation = exports.rangeOperation = {
  type: 'range',
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.intervals', {
    defaultMessage: 'Intervals'
  }),
  priority: 4,
  // Higher than terms, so numbers get histogram
  input: 'field',
  scale: column => {
    var _column$params$type, _column$params;
    const type = (_column$params$type = (_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.type) !== null && _column$params$type !== void 0 ? _column$params$type : _constants.MODES.Histogram;
    return type === _constants.MODES.Histogram ? 'interval' : 'ordinal';
  },
  getErrorMessage: (layer, columnId, indexPattern) => (0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern),
  getPossibleOperationForField: ({
    aggregationRestrictions,
    aggregatable,
    type
  }) => {
    if (type === 'number' && aggregatable && (!aggregationRestrictions || aggregationRestrictions.range)) {
      return {
        dataType: 'number',
        isBucketed: true,
        scale: 'interval'
      };
    }
  },
  getDefaultLabel: (column, columns, indexPattern) => {
    var _indexPattern$getFiel, _indexPattern$getFiel2;
    return (_indexPattern$getFiel = indexPattern === null || indexPattern === void 0 ? void 0 : (_indexPattern$getFiel2 = indexPattern.getFieldByName(column.sourceField)) === null || _indexPattern$getFiel2 === void 0 ? void 0 : _indexPattern$getFiel2.displayName) !== null && _indexPattern$getFiel !== void 0 ? _indexPattern$getFiel : _i18n.i18n.translate('xpack.lens.indexPattern.missingFieldLabel', {
      defaultMessage: 'Missing field'
    });
  },
  buildColumn({
    field
  }, columnParams) {
    var _columnParams$type, _columnParams$include, _columnParams$type2, _columnParams$ranges, _columnParams$maxBars;
    const type = (_columnParams$type = columnParams === null || columnParams === void 0 ? void 0 : columnParams.type) !== null && _columnParams$type !== void 0 ? _columnParams$type : _constants.MODES.Histogram;
    return {
      label: field.displayName,
      dataType: type === _constants.MODES.Histogram ? 'number' : 'string',
      // string for Range
      operationType: 'range',
      sourceField: field.name,
      isBucketed: true,
      params: {
        includeEmptyRows: (_columnParams$include = columnParams === null || columnParams === void 0 ? void 0 : columnParams.includeEmptyRows) !== null && _columnParams$include !== void 0 ? _columnParams$include : true,
        type: (_columnParams$type2 = columnParams === null || columnParams === void 0 ? void 0 : columnParams.type) !== null && _columnParams$type2 !== void 0 ? _columnParams$type2 : _constants.MODES.Histogram,
        ranges: (_columnParams$ranges = columnParams === null || columnParams === void 0 ? void 0 : columnParams.ranges) !== null && _columnParams$ranges !== void 0 ? _columnParams$ranges : [{
          from: 0,
          to: _constants.DEFAULT_INTERVAL,
          label: ''
        }],
        maxBars: (_columnParams$maxBars = columnParams === null || columnParams === void 0 ? void 0 : columnParams.maxBars) !== null && _columnParams$maxBars !== void 0 ? _columnParams$maxBars : _constants.AUTO_BARS,
        format: columnParams === null || columnParams === void 0 ? void 0 : columnParams.format,
        parentFormat: columnParams === null || columnParams === void 0 ? void 0 : columnParams.parentFormat
      }
    };
  },
  isTransferable: (column, newIndexPattern) => {
    const newField = newIndexPattern.getFieldByName(column.sourceField);
    return Boolean(newField && newField.type === 'number' && newField.aggregatable && (!newField.aggregationRestrictions || newField.aggregationRestrictions.range));
  },
  onFieldChange: (oldColumn, field) => {
    return {
      ...oldColumn,
      label: field.name,
      sourceField: field.name
    };
  },
  toESQL: (column, columnId, _indexPattern, layer, uiSettings) => {
    return undefined;
  },
  toEsAggsFn: (column, columnId, indexPattern, layer, uiSettings) => {
    const {
      sourceField,
      params
    } = column;
    if (params.type === _constants.MODES.Range) {
      return (0, _public2.buildExpressionFunction)('aggRange', {
        id: columnId,
        enabled: true,
        schema: 'segment',
        field: sourceField,
        ranges: params.ranges.filter(isValidRange).map(range => {
          if (isFullRange(range)) {
            return range;
          }
          const partialRange = {
            label: range.label
          };
          // be careful with the fields to set on partial ranges
          if ((0, _helpers.isValidNumber)(range.from)) {
            partialRange.from = Number(range.from);
          }
          if ((0, _helpers.isValidNumber)(range.to)) {
            partialRange.to = Number(range.to);
          }
          return partialRange;
        }).map(_common.numericalRangeToAst)
      }).toAst();
    }
    const maxBarsDefaultValue = (uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_MAX_BARS) - _constants.MIN_HISTOGRAM_BARS) / 2;
    return (0, _public2.buildExpressionFunction)('aggHistogram', {
      id: columnId,
      enabled: true,
      schema: 'segment',
      field: sourceField,
      maxBars: params.maxBars === _constants.AUTO_BARS ? maxBarsDefaultValue : params.maxBars,
      interval: 'auto',
      has_extended_bounds: false,
      min_doc_count: Boolean(params.includeEmptyRows),
      autoExtendBounds: Boolean(params.includeEmptyRows),
      extended_bounds: (0, _common.extendedBoundsToAst)({})
    }).toAst();
  },
  paramEditor: ({
    layer,
    columnId,
    currentColumn,
    paramEditorUpdater,
    indexPattern,
    uiSettings,
    fieldFormats
  }) => {
    var _numberFormat$params, _currentColumn$params;
    const currentField = indexPattern.getFieldByName(currentColumn.sourceField);
    const numberFormat = currentColumn.params.format;
    const numberFormatterPattern = numberFormat && _supported_formats.supportedFormats[numberFormat.id] && _supported_formats.supportedFormats[numberFormat.id].decimalsToPattern(((_numberFormat$params = numberFormat.params) === null || _numberFormat$params === void 0 ? void 0 : _numberFormat$params.decimals) || 0);
    const numberFormatId = numberFormat && _supported_formats.supportedFormats[numberFormat.id].formatId;
    const rangeFormatter = fieldFormats.deserialize({
      ...(currentColumn.params.parentFormat || {
        id: 'range'
      }),
      params: {
        ...((_currentColumn$params = currentColumn.params.parentFormat) === null || _currentColumn$params === void 0 ? void 0 : _currentColumn$params.params),
        ...(numberFormat ? {
          id: numberFormatId,
          params: {
            pattern: numberFormatterPattern
          }
        } : getFieldDefaultFormat(indexPattern, currentField))
      }
    });
    const MAX_HISTOGRAM_BARS = uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_MAX_BARS);
    const granularityStep = (MAX_HISTOGRAM_BARS - _constants.MIN_HISTOGRAM_BARS) / _constants.SLICES;
    const maxBarsDefaultValue = (MAX_HISTOGRAM_BARS - _constants.MIN_HISTOGRAM_BARS) / 2;

    // Used to change one param at the time
    const setParam = (paramName, value) => {
      paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
        layer,
        columnId,
        paramName,
        value
      }));
    };

    // Useful to change more params at once
    const onChangeMode = newMode => {
      const scale = newMode === _constants.MODES.Range ? 'ordinal' : 'interval';
      const dataType = newMode === _constants.MODES.Range ? 'string' : 'number';
      const parentFormat = newMode === _constants.MODES.Range ? {
        id: 'range',
        params: {
          template: 'arrow_right',
          replaceInfinity: true
        }
      } : undefined;
      paramEditorUpdater({
        ...layer,
        columns: {
          ...layer.columns,
          [columnId]: {
            ...currentColumn,
            scale,
            dataType,
            params: {
              type: newMode,
              ranges: [{
                from: 0,
                to: _constants.DEFAULT_INTERVAL,
                label: ''
              }],
              maxBars: maxBarsDefaultValue,
              format: currentColumn.params.format,
              parentFormat
            }
          }
        }
      });
    };
    return /*#__PURE__*/_react.default.createElement(_range_editor.RangeEditor, {
      setParam: setParam,
      maxBars: currentColumn.params.maxBars === _constants.AUTO_BARS ? maxBarsDefaultValue : currentColumn.params.maxBars,
      granularityStep: granularityStep,
      params: currentColumn.params,
      onChangeMode: onChangeMode,
      maxHistogramBars: uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      rangeFormatter: rangeFormatter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 7
      }
    });
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.documentation.quick', {
    defaultMessage: `
    Buckets values along defined numeric ranges.
      `
  })
};