"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.percentileRanksOperation = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/expressions-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _helpers = require("./helpers");
var _time_scale_utils = require("../time_scale_utils");
var _shared_components = require("./shared_components");
var _reduced_time_range_utils = require("../../reduced_time_range_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/percentile_ranks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ofName(name, value, timeShift, reducedTimeRange) {
  return (0, _time_scale_utils.adjustTimeScaleLabelSuffix)(_i18n.i18n.translate('xpack.lens.indexPattern.percentileRanksOf', {
    defaultMessage: 'Percentile rank ({value}) of {name}',
    values: {
      name,
      value
    }
  }), undefined, undefined, undefined, timeShift, undefined, reducedTimeRange);
}
const DEFAULT_PERCENTILE_RANKS_VALUE = 0;
const supportedFieldTypes = ['number', 'histogram'];
const percentileRanksOperation = exports.percentileRanksOperation = {
  type: _lensFormulaDocs.PERCENTILE_RANK_ID,
  allowAsReference: true,
  displayName: _lensFormulaDocs.PERCENTILE_RANK_NAME,
  input: 'field',
  operationParams: [{
    name: 'value',
    type: 'number',
    required: false,
    defaultValue: DEFAULT_PERCENTILE_RANKS_VALUE
  }],
  filterable: true,
  shiftable: true,
  canReduceTimeRange: true,
  getPossibleOperationForField: ({
    aggregationRestrictions,
    aggregatable,
    type: fieldType,
    timeSeriesMetric
  }) => {
    if (supportedFieldTypes.includes(fieldType) && aggregatable && timeSeriesMetric !== 'counter' && (!aggregationRestrictions || !aggregationRestrictions.percentile_ranks)) {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    }
  },
  isTransferable: (column, newIndexPattern) => {
    const newField = newIndexPattern.getFieldByName(column.sourceField);
    return Boolean(newField && supportedFieldTypes.includes(newField.type) && newField.aggregatable && (!newField.aggregationRestrictions || !newField.aggregationRestrictions.percentile_ranks));
  },
  getDefaultLabel: (column, columns, indexPattern) => ofName((0, _helpers.getSafeName)(column.sourceField, indexPattern), column.params.value, column.timeShift, column.reducedTimeRange),
  buildColumn: ({
    field,
    previousColumn,
    indexPattern
  }, columnParams) => {
    var _columnParams$value;
    const existingPercentileRanksParam = previousColumn && (0, _helpers.isColumnOfType)('percentile_rank', previousColumn) && previousColumn.params.value;
    const newPercentileRanksParam = (_columnParams$value = columnParams === null || columnParams === void 0 ? void 0 : columnParams.value) !== null && _columnParams$value !== void 0 ? _columnParams$value : existingPercentileRanksParam || DEFAULT_PERCENTILE_RANKS_VALUE;
    return {
      label: ofName((0, _helpers.getSafeName)(field.name, indexPattern), newPercentileRanksParam, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      dataType: 'number',
      operationType: 'percentile_rank',
      sourceField: field.name,
      isBucketed: false,
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      reducedTimeRange: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.reducedTimeRange) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      params: {
        value: newPercentileRanksParam,
        ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn)
      }
    };
  },
  onFieldChange: (oldColumn, field) => {
    return {
      ...oldColumn,
      label: ofName(field.displayName, oldColumn.params.value, oldColumn.timeShift, oldColumn.reducedTimeRange),
      sourceField: field.name
    };
  },
  toEsAggsFn: (column, columnId, _indexPattern) => {
    return (0, _public.buildExpressionFunction)('aggSinglePercentileRank', {
      id: columnId,
      enabled: true,
      schema: 'metric',
      field: column.sourceField,
      value: column.params.value,
      // time shift is added to wrapping aggFilteredMetric if filter is set
      timeShift: column.filter ? undefined : column.timeShift
    }).toAst();
  },
  getErrorMessage: (layer, columnId, indexPattern) => [...(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), ...(0, _reduced_time_range_utils.getColumnReducedTimeRangeError)(layer, columnId, indexPattern)],
  paramEditor: function PercentileParamEditor({
    paramEditorUpdater,
    currentColumn,
    indexPattern,
    paramEditorCustomProps
  }) {
    const {
      labels,
      isInline
    } = paramEditorCustomProps || {};
    const percentileRanksLabel = (labels === null || labels === void 0 ? void 0 : labels[0]) || _i18n.i18n.translate('xpack.lens.indexPattern.percentile.percentileRanksValue', {
      defaultMessage: 'Percentile ranks value'
    });
    const onChange = (0, _react.useCallback)(value => {
      var _indexPattern$getFiel;
      if (!(0, _helpers.isValidNumber)(value, isInline) || Number(value) === currentColumn.params.value) {
        return;
      }
      paramEditorUpdater({
        ...currentColumn,
        label: currentColumn.customLabel ? currentColumn.label : ofName(((_indexPattern$getFiel = indexPattern.getFieldByName(currentColumn.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.displayName) || currentColumn.sourceField, Number(value), currentColumn.timeShift, currentColumn.reducedTimeRange),
        params: {
          ...currentColumn.params,
          value: Number(value)
        }
      });
    }, [isInline, currentColumn, paramEditorUpdater, indexPattern]);
    const {
      inputValue,
      handleInputChange: handleInputChangeWithoutValidation
    } = (0, _visualizationUtils.useDebouncedValue)({
      onChange,
      value: String(currentColumn.params.value)
    }, {
      allowFalsyValue: true
    });
    const inputValueIsValid = (0, _helpers.isValidNumber)(inputValue, isInline);
    const handleInputChange = (0, _react.useCallback)(e => {
      handleInputChangeWithoutValidation(e.currentTarget.value);
    }, [handleInputChangeWithoutValidation]);
    return /*#__PURE__*/_react.default.createElement(_shared_components.FormRow, {
      isInline: isInline,
      label: percentileRanksLabel,
      "data-test-subj": "lns-indexPattern-percentile_ranks-form",
      display: "rowCompressed",
      fullWidth: true,
      isInvalid: !inputValueIsValid,
      error: !inputValueIsValid && _i18n.i18n.translate('xpack.lens.indexPattern.percentileRanks.errorMessage', {
        defaultMessage: 'Percentile ranks value must be a number'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      fullWidth: true,
      "data-test-subj": "lns-indexPattern-percentile_ranks-input",
      compressed: true,
      value: inputValue !== null && inputValue !== void 0 ? inputValue : '',
      onChange: handleInputChange,
      step: isInline ? 1 : 'any',
      "aria-label": percentileRanksLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    }));
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.percentileRanks.documentation.quick', {
    defaultMessage: `
The percentage of values that are below a specific value. For example, when a value is greater than or equal to 95% of the calculated values, the value is the 95th percentile rank.
      `
  })
};