"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formulaOperationName = exports.DimensionEditorButtonGroups = exports.CalloutWarning = void 0;
exports.getParamEditor = getParamEditor;
exports.isLayerChangingDueToDecimalsPercentile = isLayerChangingDueToDecimalsPercentile;
exports.isLayerChangingDueToOtherBucketChange = isLayerChangingDueToOtherBucketChange;
exports.isQuickFunction = isQuickFunction;
exports.termsOperationName = exports.staticValueOperationName = exports.quickFunctionsName = exports.optionallySortableOperationNames = exports.nonQuickFunctions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _utils = require("../../../utils");
var _operations = require("../operations");
var _helpers = require("../operations/definitions/helpers");
var _constants = require("../operations/definitions/terms/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/dimensions_editor_helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const formulaOperationName = exports.formulaOperationName = 'formula';
const staticValueOperationName = exports.staticValueOperationName = 'static_value';
const quickFunctionsName = exports.quickFunctionsName = 'quickFunctions';
const termsOperationName = exports.termsOperationName = 'terms';
const optionallySortableOperationNames = exports.optionallySortableOperationNames = ['percentile', 'percentile_ranks'];
const nonQuickFunctions = exports.nonQuickFunctions = new Set([formulaOperationName, staticValueOperationName]);
function isLayerChangingDueToOtherBucketChange(prevLayer, newLayer) {
  // Finds the other bucket in prevState and return its value
  const prevStateTermsColumns = Object.entries(prevLayer.columns).map(([id, column]) => {
    if ((0, _helpers.isColumnOfType)('terms', column)) {
      return {
        id,
        otherBucket: column.params.otherBucket,
        termsSize: column.params.size
      };
    }
  }).filter(_utils.nonNullable);
  // Checks if the terms columns have changed the otherBucket value programatically.
  // This happens when the terms size is greater than equal MAX_TERMS_OTHER_ENABLED
  // and the previous state terms size is lower than MAX_TERMS_OTHER_ENABLED
  const hasChangedOtherBucket = prevStateTermsColumns.some(({
    id,
    otherBucket,
    termsSize
  }) => {
    const newStateTermsColumn = newLayer.columns[id];
    if (!(0, _helpers.isColumnOfType)('terms', newStateTermsColumn)) {
      return false;
    }
    return newStateTermsColumn.params.otherBucket !== otherBucket && !newStateTermsColumn.params.otherBucket && newStateTermsColumn.params.size >= _constants.MAX_TERMS_OTHER_ENABLED && termsSize < _constants.MAX_TERMS_OTHER_ENABLED;
  });
  return hasChangedOtherBucket;
}
function isLayerChangingDueToDecimalsPercentile(prevLayer, newLayer) {
  // step 1: find the ranking column in prevState and return its value
  const termsRiskyColumns = Object.entries(prevLayer.columns).map(([id, column]) => {
    var _column$params;
    if ((0, _helpers.isColumnOfType)('terms', column) && ((_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.orderBy.type) === 'column' && column.params.orderBy.columnId != null) {
      const rankingColumn = prevLayer.columns[column.params.orderBy.columnId];
      if ((0, _helpers.isColumnOfType)('percentile', rankingColumn)) {
        if (Number.isInteger(rankingColumn.params.percentile)) {
          return {
            id,
            rankId: column.params.orderBy.columnId
          };
        }
      }
      if ((0, _helpers.isColumnOfType)('percentile_rank', rankingColumn)) {
        if (Number.isInteger(rankingColumn.params.value)) {
          return {
            id,
            rankId: column.params.orderBy.columnId
          };
        }
      }
    }
  }).filter(_utils.nonNullable);
  // now check again the terms risky column in the new layer and verify that at
  // least one changed due to decimals
  const hasChangedDueToDecimals = termsRiskyColumns.some(({
    id,
    rankId
  }) => {
    const termsColumn = newLayer.columns[id];
    if (!(0, _helpers.isColumnOfType)('terms', termsColumn)) {
      return false;
    }
    if (termsColumn.params.orderBy.type === 'alphabetical') {
      const rankingColumn = newLayer.columns[rankId];
      if ((0, _helpers.isColumnOfType)('percentile', rankingColumn)) {
        return !Number.isInteger(rankingColumn.params.percentile);
      }
      if ((0, _helpers.isColumnOfType)('percentile_rank', rankingColumn)) {
        return !Number.isInteger(rankingColumn.params.value);
      }
    }
  });
  return hasChangedDueToDecimals;
}
function isQuickFunction(operationType) {
  return !nonQuickFunctions.has(operationType);
}
function getParamEditor(temporaryStaticValue, selectedOperationDefinition, showDefaultStaticValue) {
  if (temporaryStaticValue) {
    return _operations.operationDefinitionMap[staticValueOperationName].paramEditor;
  }
  if (selectedOperationDefinition !== null && selectedOperationDefinition !== void 0 && selectedOperationDefinition.paramEditor) {
    return selectedOperationDefinition.paramEditor;
  }
  if (showDefaultStaticValue) {
    return _operations.operationDefinitionMap[staticValueOperationName].paramEditor;
  }
  return null;
}
const CalloutWarning = ({
  currentOperationType,
  temporaryStateType
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  if (temporaryStateType === 'none' || currentOperationType != null && isQuickFunction(currentOperationType)) {
    return null;
  }
  if (currentOperationType === staticValueOperationName && temporaryStateType === 'quickFunctions') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: false,
      css: dimensionEditorWarningStyles(euiThemeContext),
      size: "s",
      title: _i18n.i18n.translate('xpack.lens.indexPattern.staticValueWarning', {
        defaultMessage: 'Static value currently applied'
      }),
      iconType: "warning",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.staticValueWarningText', {
      defaultMessage: 'To overwrite your static value, select a quick function'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    css: dimensionEditorWarningStyles(euiThemeContext),
    size: "s",
    title: _i18n.i18n.translate('xpack.lens.indexPattern.formulaWarning', {
      defaultMessage: 'Formula currently applied'
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, temporaryStateType !== 'quickFunctions' ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.formulaWarningStaticValueText', {
    defaultMessage: 'To overwrite your formula, change the value in the input field'
  })) : /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.formulaWarningText', {
    defaultMessage: 'To overwrite your formula, select a quick function'
  }))));
};
exports.CalloutWarning = CalloutWarning;
const DimensionEditorButtonGroups = ({
  options,
  onMethodChange,
  selectedMethod
}) => {
  const enabledGroups = options.filter(({
    enabled
  }) => enabled);
  const groups = enabledGroups.map(({
    id,
    label
  }) => {
    return {
      id,
      label,
      'data-test-subj': `lens-dimensionTabs-${id}`
    };
  });
  const onChange = optionId => {
    onMethodChange(optionId);
    const selectedOption = options.find(({
      id
    }) => id === optionId);
    selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.onClick();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditor.headingMethod', {
      defaultMessage: 'Method'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditorModes', {
      defaultMessage: 'Dimension editor configuration modes'
    }),
    buttonSize: "compressed",
    isFullWidth: true,
    options: groups,
    idSelected: selectedMethod,
    onChange: id => onChange(id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }));
};
exports.DimensionEditorButtonGroups = DimensionEditorButtonGroups;
const dimensionEditorWarningStyles = ({
  euiTheme
}) => {
  return (0, _react2.css)`
    margin-bottom: ${euiTheme.size.base};
    margin-top: ${euiTheme.size.s};
  `;
};