"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.attributesCleanup = attributesCleanup;
var _lensCommon = require("@kbn/lens-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Cleanup null and loose SO attribute types
 * - `description` should not allow `null`
 * - `visualizationType` should not allow `null` or `undefined`
 */
function attributesCleanup(attributes) {
  var _attributes$descripti, _attributes$visualiza;
  return {
    ...attributes,
    // fix type mismatches, null -> undefined
    description: (_attributes$descripti = attributes.description) !== null && _attributes$descripti !== void 0 ? _attributes$descripti : undefined,
    // fix type mismatches, null | undefined -> string
    visualizationType: (_attributes$visualiza = attributes.visualizationType) !== null && _attributes$visualiza !== void 0 ? _attributes$visualiza : _lensCommon.LENS_UNKNOWN_VIS // should never happen
  };
}