"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromMovingAverageAPItoLensState = fromMovingAverageAPItoLensState;
exports.fromMovingAverageLensStateToAPI = fromMovingAverageLensStateToAPI;
var _utils = require("./utils");
var _format = require("./format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromMovingAverageAPItoLensState(options, ref) {
  return {
    operationType: 'moving_average',
    references: [ref.id],
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    params: {
      window: options.window,
      ...(options.format ? {
        format: (0, _format.fromFormatAPIToLensState)(options.format)
      } : {})
    }
  };
}
function fromMovingAverageLensStateToAPI(column, ref) {
  var _column$params;
  return {
    operation: 'moving_average',
    ...(0, _utils.getLensAPIMetricSharedProps)(column),
    of: ref,
    window: column.params.window,
    ...((_column$params = column.params) !== null && _column$params !== void 0 && _column$params.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(column.params.format)
    } : {})
  };
}