"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromFormatAPIToLensState = fromFormatAPIToLensState;
exports.fromFormatLensStateToAPI = fromFormatLensStateToAPI;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromFormatAPIToLensState(format) {
  if (!format) {
    return;
  }
  if (format.type === 'number' || format.type === 'percent') {
    return {
      id: format.type,
      params: {
        decimals: format.decimals,
        ...(format.suffix ? {
          suffix: format.suffix
        } : {}),
        ...(format.compact != null ? {
          compact: format.compact
        } : {})
      }
    };
  }
  if (format.type === 'bits' || format.type === 'bytes') {
    return {
      id: format.type,
      params: {
        decimals: format.decimals,
        ...(format.suffix ? {
          suffix: format.suffix
        } : {})
      }
    };
  }
  if (format.type === 'duration') {
    return {
      id: format.type,
      params: {
        // doesn't matter, it's will be ignored but want to make TS happy
        decimals: 2,
        fromUnit: format.from,
        toUnit: format.to,
        ...(format.suffix ? {
          suffix: format.suffix
        } : {})
      }
    };
  }
  if (format.type === 'custom') {
    return {
      id: format.type,
      params: {
        // doesn't matter, it's will be ignored but want to make TS happy
        decimals: 2,
        pattern: format.pattern
      }
    };
  }
}
function fromFormatLensStateToAPI(format) {
  var _format$params9, _format$params10, _format$params14;
  if (!format) {
    return;
  }
  if (format.id === 'number' || format.id === 'percent') {
    var _format$params, _format$params2, _format$params3, _format$params4, _format$params5;
    return {
      type: format.id,
      ...(((_format$params = format.params) === null || _format$params === void 0 ? void 0 : _format$params.decimals) != null ? {
        decimals: (_format$params2 = format.params) === null || _format$params2 === void 0 ? void 0 : _format$params2.decimals
      } : {}),
      ...(((_format$params3 = format.params) === null || _format$params3 === void 0 ? void 0 : _format$params3.compact) != null ? {
        compact: (_format$params4 = format.params) === null || _format$params4 === void 0 ? void 0 : _format$params4.compact
      } : {}),
      ...((_format$params5 = format.params) !== null && _format$params5 !== void 0 && _format$params5.suffix ? {
        suffix: format.params.suffix
      } : {})
    };
  }
  if (format.id === 'bits' || format.id === 'bytes') {
    var _format$params6, _format$params7, _format$params8;
    return {
      type: format.id,
      ...(((_format$params6 = format.params) === null || _format$params6 === void 0 ? void 0 : _format$params6.decimals) != null ? {
        decimals: (_format$params7 = format.params) === null || _format$params7 === void 0 ? void 0 : _format$params7.decimals
      } : {}),
      ...((_format$params8 = format.params) !== null && _format$params8 !== void 0 && _format$params8.suffix ? {
        suffix: format.params.suffix
      } : {})
    };
  }
  if (format.id === 'duration' && (_format$params9 = format.params) !== null && _format$params9 !== void 0 && _format$params9.fromUnit && (_format$params10 = format.params) !== null && _format$params10 !== void 0 && _format$params10.toUnit) {
    var _format$params11, _format$params12, _format$params13;
    return {
      type: format.id,
      from: (_format$params11 = format.params) === null || _format$params11 === void 0 ? void 0 : _format$params11.fromUnit,
      to: (_format$params12 = format.params) === null || _format$params12 === void 0 ? void 0 : _format$params12.toUnit,
      ...((_format$params13 = format.params) !== null && _format$params13 !== void 0 && _format$params13.suffix ? {
        suffix: format.params.suffix
      } : {})
    };
  }
  if (format.id === 'custom' && (_format$params14 = format.params) !== null && _format$params14 !== void 0 && _format$params14.pattern) {
    var _format$params15;
    return {
      type: format.id,
      pattern: (_format$params15 = format.params) === null || _format$params15 === void 0 ? void 0 : _format$params15.pattern
    };
  }
}