"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromCountLensStateToAPI = exports.fromCountAPItoLensState = void 0;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromCountAPItoLensState = options => {
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    empty_as_null,
    format,
    field
  } = options;
  return {
    operationType: 'count',
    sourceField: field || '___records___',
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    params: {
      emptyAsNull: empty_as_null,
      ...(format ? {
        format: (0, _format.fromFormatAPIToLensState)(format)
      } : {})
    }
  };
};
exports.fromCountAPItoLensState = fromCountAPItoLensState;
const fromCountLensStateToAPI = options => {
  var _options$params, _options$params2;
  return {
    operation: 'count',
    ...(options.sourceField !== '___records___' ? {
      field: options.sourceField
    } : {}),
    empty_as_null: Boolean((_options$params = options.params) === null || _options$params === void 0 ? void 0 : _options$params.emptyAsNull),
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...((_options$params2 = options.params) !== null && _options$params2 !== void 0 && _options$params2.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
};
exports.fromCountLensStateToAPI = fromCountLensStateToAPI;