"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LENS_METRIC_COMPARE_TO_PALETTE_DEFAULT = void 0;
exports.fromAPItoLensState = fromAPItoLensState;
exports.fromLensStateToAPI = fromLensStateToAPI;
var _types = require("../../types");
var _utils = require("../utils");
var _buckets = require("../columns/buckets");
var _esql_column = require("../columns/esql_column");
var _metric = require("../columns/metric");
var _utils2 = require("./utils");
var _coloring = require("../coloring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'metric_formula_accessor';
const HISTOGRAM_COLUMN_NAME = 'x_date_histogram';
const TRENDLINE_LAYER_ID = 'layer_0_trendline';
const LENS_METRIC_COMPARE_TO_PALETTE_DEFAULT = exports.LENS_METRIC_COMPARE_TO_PALETTE_DEFAULT = 'compare_to';
const LENS_METRIC_COMPARE_TO_REVERSED = false;
const LENS_DEFAULT_LAYER_ID = 'layer_0';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function fromCompareAPIToLensState(compareToConfig) {
  var _compareToConfig$pale, _compareToConfig$pale2, _compareToConfig$pale3;
  return {
    secondaryTrend: {
      type: 'dynamic',
      baselineValue: compareToConfig.to === 'primary' ? compareToConfig.to : compareToConfig.baseline,
      visuals: compareToConfig.icon && compareToConfig.value ? 'both' : compareToConfig.icon ? 'icon' : 'value',
      reversed: (_compareToConfig$pale = (_compareToConfig$pale2 = compareToConfig.palette) === null || _compareToConfig$pale2 === void 0 ? void 0 : _compareToConfig$pale2.includes('reversed')) !== null && _compareToConfig$pale !== void 0 ? _compareToConfig$pale : LENS_METRIC_COMPARE_TO_REVERSED,
      paletteId: (_compareToConfig$pale3 = compareToConfig.palette) !== null && _compareToConfig$pale3 !== void 0 ? _compareToConfig$pale3 : LENS_METRIC_COMPARE_TO_PALETTE_DEFAULT
    }
  };
}
function buildVisualizationState(config) {
  var _layer$metric$color, _layer$metric$color2, _layer$metric$sub_lab, _layer$metric$alignme, _layer$secondary_metr, _layer$breakdown_by, _layer$metric, _layer$metric$backgro, _layer$metric$backgro2;
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    layerType: 'data',
    metricAccessor: getAccessorName('metric'),
    ...(((_layer$metric$color = layer.metric.color) === null || _layer$metric$color === void 0 ? void 0 : _layer$metric$color.type) === 'static' ? (0, _coloring.fromStaticColorAPIToLensState)(layer.metric.color) : {}),
    ...(((_layer$metric$color2 = layer.metric.color) === null || _layer$metric$color2 === void 0 ? void 0 : _layer$metric$color2.type) === 'dynamic' ? {
      palette: (0, _coloring.fromColorByValueAPIToLensState)(layer.metric.color)
    } : {}),
    ...(layer.metric.apply_color_to ? {
      applyColorTo: layer.metric.apply_color_to
    } : {}),
    subtitle: (_layer$metric$sub_lab = layer.metric.sub_label) !== null && _layer$metric$sub_lab !== void 0 ? _layer$metric$sub_lab : '',
    showBar: false,
    valueFontMode: layer.metric.fit ? 'fit' : 'default',
    ...(layer.metric.alignments ? {
      valuesTextAlign: layer.metric.alignments.value,
      titlesTextAlign: layer.metric.alignments.labels
    } : {}),
    ...(layer.metric.icon ? {
      icon: layer.metric.icon.name,
      iconAlign: layer.metric.icon.align
    } : {}),
    ...(layer.secondary_metric ? {
      secondaryMetricAccessor: getAccessorName('secondary'),
      secondaryPrefix: layer.secondary_metric.prefix,
      secondaryAlign: (_layer$metric$alignme = layer.metric.alignments) === null || _layer$metric$alignme === void 0 ? void 0 : _layer$metric$alignme.value,
      ...(layer.secondary_metric.compare ? fromCompareAPIToLensState(layer.secondary_metric.compare) : {}),
      ...(((_layer$secondary_metr = layer.secondary_metric.color) === null || _layer$secondary_metr === void 0 ? void 0 : _layer$secondary_metr.type) === 'static' ? {
        secondaryTrend: {
          type: 'static',
          color: layer.secondary_metric.color.color
        }
      } : {})
    } : {}),
    ...(layer.breakdown_by ? {
      breakdownByAccessor: getAccessorName('breakdown'),
      maxCols: layer.breakdown_by.columns
    } : {}),
    collapseFn: (_layer$breakdown_by = layer.breakdown_by) === null || _layer$breakdown_by === void 0 ? void 0 : _layer$breakdown_by.collapse_by,
    ...(((_layer$metric = layer.metric) === null || _layer$metric === void 0 ? void 0 : (_layer$metric$backgro = _layer$metric.background_chart) === null || _layer$metric$backgro === void 0 ? void 0 : _layer$metric$backgro.type) === 'bar' ? {
      maxAccessor: getAccessorName('max'),
      showBar: true,
      progressDirection: layer.metric.background_chart.direction
    } : {}),
    ...(((_layer$metric$backgro2 = layer.metric.background_chart) === null || _layer$metric$backgro2 === void 0 ? void 0 : _layer$metric$backgro2.type) === 'trend' ? {
      trendlineLayerId: `${_types.DEFAULT_LAYER_ID}_trendline`,
      trendlineLayerType: 'metricTrendline',
      trendlineMetricAccessor: `${ACCESSOR}_trendline`,
      trendlineTimeAccessor: HISTOGRAM_COLUMN_NAME,
      ...(layer.secondary_metric ? {
        trendlineSecondaryMetricAccessor: `${ACCESSOR}_secondary_trendline`
      } : {}),
      ...(layer.breakdown_by ? {
        trendlineBreakdownByAccessor: `${ACCESSOR}_breakdown_trendline`
      } : {})
    } : {})
  };
}
function fromCompareLensStateToAPI(compare) {
  const sharedProps = {
    palette: `${compare.paletteId}${compare.reversed ? '_reversed' : ''}`,
    icon: compare.visuals === 'icon' || compare.visuals === 'both',
    value: compare.visuals === 'value' || compare.visuals === 'both'
  };
  if (compare.baselineValue === 'primary') {
    return {
      to: 'primary',
      ...sharedProps
    };
  }
  return {
    to: 'baseline',
    baseline: compare.baselineValue,
    ...sharedProps
  };
}
function reverseBuildVisualizationState(visualization, layer, layerId, adHocDataViews, references, adhocReferences) {
  const metricAccessor = (0, _utils2.getMetricAccessor)(visualization);
  if (metricAccessor == null) {
    throw new Error('Metric accessor is missing in the visualization state');
  }
  const dataset = (0, _utils.buildDatasetState)(layer, adHocDataViews, references, adhocReferences, layerId);
  if (!dataset || dataset.type == null) {
    throw new Error('Unsupported dataset type');
  }
  let props = (0, _utils.generateApiLayer)(layer);
  if (dataset.type === 'esql' || dataset.type === 'table') {
    const esqlLayer = layer;
    props = {
      ...props,
      metric: (0, _esql_column.getValueApiColumn)(metricAccessor, esqlLayer),
      ...(visualization.secondaryMetricAccessor ? {
        secondary_metric: {
          ...(0, _esql_column.getValueApiColumn)(visualization.secondaryMetricAccessor, esqlLayer),
          ...(visualization.maxAccessor ? {
            background_chart: {
              type: 'bar',
              goal_value: (0, _esql_column.getValueApiColumn)(visualization.maxAccessor, esqlLayer),
              direction: visualization.progressDirection
            }
          } : {})
        }
      } : {}),
      ...(visualization.breakdownByAccessor ? {
        breakdown_by: {
          ...(0, _esql_column.getValueApiColumn)(visualization.breakdownByAccessor, esqlLayer),
          columns: visualization.maxCols
        }
      } : {})
    };
  } else if (dataset.type === 'dataView' || dataset.type === 'index') {
    var _props$metric, _props$metric2;
    const formLayer = layer;
    const metric = (0, _utils.operationFromColumn)(metricAccessor, formLayer);
    // eslint-disable-next-line @typescript-eslint/naming-convention
    const secondary_metric = visualization.secondaryMetricAccessor ? (0, _utils.operationFromColumn)(visualization.secondaryMetricAccessor, formLayer) : undefined;
    // eslint-disable-next-line @typescript-eslint/naming-convention
    const max_value = visualization.maxAccessor ? (0, _utils.operationFromColumn)(visualization.maxAccessor, formLayer) : undefined;
    // eslint-disable-next-line @typescript-eslint/naming-convention
    const breakdown_by = visualization.breakdownByAccessor ? (0, _utils.operationFromColumn)(visualization.breakdownByAccessor, formLayer) : undefined;
    props = {
      ...props,
      metric: {
        ...metric,
        ...((max_value !== null && max_value !== void 0 ? max_value : (_props$metric = props.metric) === null || _props$metric === void 0 ? void 0 : _props$metric.background_chart) ? {
          background_chart: {
            ...(max_value ? {
              type: 'bar',
              goal_value: max_value,
              direction: visualization.progressDirection
            } : (_props$metric2 = props.metric) === null || _props$metric2 === void 0 ? void 0 : _props$metric2.background_chart)
          }
        } : {})
      },
      ...(secondary_metric ? {
        secondary_metric: {
          ...secondary_metric
        }
      } : {}),
      ...(breakdown_by ? {
        breakdown_by
      } : {})
    };
  }
  if (props.metric) {
    if (visualization.subtitle) {
      props.metric.sub_label = visualization.subtitle;
    }
    if (visualization.trendlineLayerType) {
      props.metric.background_chart = {
        ...props.metric.background_chart,
        type: 'trend'
      };
    }
    if (visualization.color) {
      props.metric.color = (0, _coloring.fromStaticColorLensStateToAPI)(visualization.color);
    }
    if (visualization.palette) {
      const colorByValue = (0, _coloring.fromColorByValueLensStateToAPI)(visualization.palette);
      if ((colorByValue === null || colorByValue === void 0 ? void 0 : colorByValue.range) === 'absolute') {
        props.metric.color = colorByValue;
      }
    }
    if (visualization.applyColorTo) {
      props.metric.apply_color_to = visualization.applyColorTo;
    }
    if (visualization.icon) {
      props.metric.icon = {
        name: visualization.icon,
        align: visualization.iconAlign
      };
    }
    if (visualization.valuesTextAlign || visualization.titlesTextAlign) {
      props.metric.alignments = {
        ...(visualization.valuesTextAlign ? {
          value: visualization.valuesTextAlign
        } : {}),
        ...(visualization.titlesTextAlign ? {
          labels: visualization.titlesTextAlign
        } : {})
      };
    }
    props.metric.fit = visualization.valueFontMode === 'fit';
  }
  if (props.secondary_metric) {
    var _visualization$second, _visualization$second2, _visualization$second3;
    if (((_visualization$second = visualization.secondaryTrend) === null || _visualization$second === void 0 ? void 0 : _visualization$second.type) === 'dynamic') {
      props.secondary_metric.compare = fromCompareLensStateToAPI(visualization.secondaryTrend);
    }
    if (visualization.secondaryPrefix) {
      props.secondary_metric.prefix = visualization.secondaryPrefix;
    }
    if (((_visualization$second2 = visualization.secondaryTrend) === null || _visualization$second2 === void 0 ? void 0 : _visualization$second2.type) === 'static' && (_visualization$second3 = visualization.secondaryTrend) !== null && _visualization$second3 !== void 0 && _visualization$second3.color) {
      props.secondary_metric.color = {
        type: 'static',
        color: visualization.secondaryTrend.color
      };
    }
  }
  if (props.breakdown_by) {
    if (visualization.maxCols) {
      props.breakdown_by.columns = visualization.maxCols;
    }
    if (visualization.collapseFn) {
      props.breakdown_by.collapse_by = visualization.collapseFn;
    }
  }
  return {
    type: 'metric',
    dataset: dataset,
    ...props
  };
}
function buildFormBasedLayer(layer) {
  var _layer$metric2, _layer$metric2$backgr, _layer$metric3, _layer$metric3$backgr;
  const columns = (0, _metric.fromMetricAPItoLensState)(layer.metric);
  const layers = {
    ...(0, _utils.generateLayer)(_types.DEFAULT_LAYER_ID, layer),
    ...(((_layer$metric2 = layer.metric) === null || _layer$metric2 === void 0 ? void 0 : (_layer$metric2$backgr = _layer$metric2.background_chart) === null || _layer$metric2$backgr === void 0 ? void 0 : _layer$metric2$backgr.type) === 'trend' ? (0, _utils.generateLayer)(TRENDLINE_LAYER_ID, layer) : {})
  };
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  const trendLineLayer = layers[TRENDLINE_LAYER_ID];
  if (trendLineLayer) {
    trendLineLayer.linkToLayers = [_types.DEFAULT_LAYER_ID];
  }
  (0, _utils.addLayerColumn)(defaultLayer, getAccessorName('metric'), columns);
  if (trendLineLayer) {
    (0, _utils.addLayerColumn)(trendLineLayer, `${ACCESSOR}_trendline`, columns);
    (0, _utils.addLayerColumn)(trendLineLayer, HISTOGRAM_COLUMN_NAME, columns);
  }
  if (layer.breakdown_by) {
    const columnName = getAccessorName('breakdown');
    const breakdownColumn = (0, _buckets.fromBucketLensApiToLensState)(layer.breakdown_by, columns.map(col => ({
      column: col,
      id: getAccessorName('metric')
    })));
    (0, _utils.addLayerColumn)(defaultLayer, columnName, breakdownColumn, true);
    if (trendLineLayer) {
      (0, _utils.addLayerColumn)(trendLineLayer, `${columnName}_trendline`, breakdownColumn, true);
    }
  }
  if (layer.secondary_metric) {
    const columnName = getAccessorName('secondary');
    const newColumn = (0, _metric.fromMetricAPItoLensState)(layer.secondary_metric);
    (0, _utils.addLayerColumn)(defaultLayer, columnName, newColumn);
    if (trendLineLayer) {
      (0, _utils.addLayerColumn)(trendLineLayer, `${columnName}_trendline`, newColumn, false, 'X0');
    }
  }
  if (((_layer$metric3 = layer.metric) === null || _layer$metric3 === void 0 ? void 0 : (_layer$metric3$backgr = _layer$metric3.background_chart) === null || _layer$metric3$backgr === void 0 ? void 0 : _layer$metric3$backgr.type) === 'bar') {
    const columnName = getAccessorName('max');
    const newColumn = (0, _metric.fromMetricAPItoLensState)(layer.metric.background_chart.goal_value);
    (0, _utils.addLayerColumn)(defaultLayer, columnName, newColumn);
    if (trendLineLayer) {
      (0, _utils.addLayerColumn)(trendLineLayer, `${columnName}_trendline`, newColumn, false, 'X0');
    }
  }
  return layers;
}
function getValueColumns(layer) {
  var _layer$metric4, _layer$metric4$backgr;
  return [...(layer.breakdown_by ? [(0, _esql_column.getValueColumn)(getAccessorName('breakdown'), layer.breakdown_by.column)] : []), (0, _esql_column.getValueColumn)(getAccessorName('metric'), layer.metric.column, 'number'), ...(((_layer$metric4 = layer.metric) === null || _layer$metric4 === void 0 ? void 0 : (_layer$metric4$backgr = _layer$metric4.background_chart) === null || _layer$metric4$backgr === void 0 ? void 0 : _layer$metric4$backgr.type) === 'bar' ? [(0, _esql_column.getValueColumn)(getAccessorName('max'), layer.metric.background_chart.goal_value.operation, 'number')] : []), ...(layer.secondary_metric ? [(0, _esql_column.getValueColumn)(getAccessorName('secondary'), layer.secondary_metric.column)] : [])];
}
function fromAPItoLensState(config) {
  var _regularDataViews$;
  const _buildDataLayer = (cfg, i) => buildFormBasedLayer(cfg);
  const {
    layers,
    usedDataviews
  } = (0, _utils.buildDatasourceStates)(config, _buildDataLayer, getValueColumns);
  const visualization = buildVisualizationState(config);
  const {
    adHocDataViews,
    internalReferences
  } = (0, _utils.getAdhocDataviews)(usedDataviews);
  const regularDataViews = Object.values(usedDataviews).filter(v => v.type === 'dataView');
  const references = regularDataViews.length ? (0, _utils.buildReferences)({
    [LENS_DEFAULT_LAYER_ID]: (_regularDataViews$ = regularDataViews[0]) === null || _regularDataViews$ === void 0 ? void 0 : _regularDataViews$.id
  }) : [];
  return {
    visualizationType: 'lnsMetric',
    ...(0, _utils2.getSharedChartAPIToLensState)(config),
    references,
    state: {
      datasourceStates: layers,
      internalReferences,
      visualization,
      adHocDataViews: config.dataset.type === 'index' ? adHocDataViews : {}
    }
  };
}
function fromLensStateToAPI(config) {
  var _config$state$adHocDa;
  const {
    state
  } = config;
  const visualization = state.visualization;
  const layers = (0, _utils2.getDatasourceLayers)(state);

  // Layers can be in any order, so make sure to get the main one
  const [layerId, layer] = Object.entries(layers).find(([, l]) => !('linkToLayers' in l) || l.linkToLayers == null);
  const visualizationState = {
    ...(0, _utils2.getSharedChartLensStateToAPI)(config),
    ...reverseBuildVisualizationState(visualization, layer, layerId !== null && layerId !== void 0 ? layerId : LENS_DEFAULT_LAYER_ID, (_config$state$adHocDa = config.state.adHocDataViews) !== null && _config$state$adHocDa !== void 0 ? _config$state$adHocDa : {}, config.references, config.state.internalReferences)
  };
  return visualizationState;
}