"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterAddressForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _submit_error_callout = require("./submit_error_callout");
var _use_form = require("./use_form");
var _use_kibana = require("./use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/interactive_setup/public/cluster_address_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ClusterAddressForm = ({
  defaultValues = {
    host: 'https://localhost:9200'
  },
  onCancel,
  onSuccess
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const [form, eventHandlers] = (0, _use_form.useForm)({
    defaultValues,
    validate: async values => {
      const errors = {};
      if (!values.host) {
        errors.host = _i18n.i18n.translate('interactiveSetup.clusterAddressForm.hostRequiredError', {
          defaultMessage: 'Enter an address.'
        });
      } else {
        try {
          const url = new URL(values.host);
          if (!url.protocol || !url.hostname) {
            throw new Error();
          }
        } catch (error) {
          errors.host = _i18n.i18n.translate('interactiveSetup.clusterAddressForm.hostInvalidError', {
            defaultMessage: "Enter a valid address, including 'http' or 'https'."
          });
        }
      }
      return errors;
    },
    onSubmit: async values => {
      const url = new URL(values.host);
      const result = await http.post('/internal/interactive_setup/ping', {
        body: JSON.stringify({
          host: url.origin
        })
      });
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(result, {
        host: url.origin
      });
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, (0, _extends2.default)({
    component: "form",
    noValidate: true
  }, eventHandlers, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }), form.submitError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_submit_error_callout.SubmitErrorCallout, {
    error: form.submitError,
    defaultTitle: _i18n.i18n.translate('interactiveSetup.clusterAddressForm.submitErrorTitle', {
      defaultMessage: "Couldn't check address"
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('interactiveSetup.clusterAddressForm.hostLabel', {
      defaultMessage: 'Address'
    }),
    error: form.errors.host,
    isInvalid: form.touched.host && !!form.errors.host,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "host",
    value: form.values.host,
    isInvalid: form.touched.host && !!form.errors.host,
    placeholder: "https://localhost:9200",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "right",
    iconType: "arrowLeft",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.clusterAddressForm.cancelButton",
    defaultMessage: "Back",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    isLoading: form.isSubmitting,
    isDisabled: form.isSubmitted && form.isInvalid,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.clusterAddressForm.submitButton",
    defaultMessage: "{isSubmitting, select, true{Checking address\u2026} other{Check address}}",
    values: {
      isSubmitting: form.isSubmitting
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  })))));
};
exports.ClusterAddressForm = ClusterAddressForm;