"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestDetails = RequestDetails;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_next_tab = require("./get_next_tab");
var _details = require("./details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/views/requests/components/request_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETAILS = [{
  name: 'Statistics',
  label: _i18n.i18n.translate('inspector.requests.statisticsTabLabel', {
    defaultMessage: 'Statistics'
  }),
  component: _details.RequestDetailsStats
}, {
  name: 'Clusters',
  label: _i18n.i18n.translate('inspector.requests.clustersTabLabel', {
    defaultMessage: 'Clusters and shards'
  }),
  component: _details.ClustersView
}, {
  name: 'Request',
  label: _i18n.i18n.translate('inspector.requests.requestTabLabel', {
    defaultMessage: 'Request'
  }),
  component: _details.RequestDetailsRequest
}, {
  name: 'Response',
  label: _i18n.i18n.translate('inspector.requests.responseTabLabel', {
    defaultMessage: 'Response'
  }),
  component: _details.RequestDetailsResponse
}];
function RequestDetails(props) {
  const [availableDetails, setAvailableDetails] = (0, _react.useState)([]);
  const [selectedDetail, setSelectedDetail] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    const nextAvailableDetails = DETAILS.filter(detail => {
      var _detail$component$sho, _detail$component;
      return (_detail$component$sho = (_detail$component = detail.component).shouldShow) === null || _detail$component$sho === void 0 ? void 0 : _detail$component$sho.call(_detail$component, props.request);
    });
    setAvailableDetails(nextAvailableDetails);

    // If the previously selected detail is still available we want to stay
    // on this tab and not set another selectedDetail.
    if (selectedDetail && nextAvailableDetails.find(({
      name
    }) => name === selectedDetail.name)) {
      return;
    }
    setSelectedDetail((0, _get_next_tab.getNextTab)(selectedDetail, nextAvailableDetails, props.initialTabs));

    // do not re-run on selectedDetail change
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [props.initialTabs, props.request]);
  return selectedDetail ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, availableDetails.map(detail => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: detail.name,
    isSelected: detail.name === selectedDetail.name,
    onClick: () => {
      if (detail.name !== selectedDetail.name) {
        setSelectedDetail(detail);
      }
    },
    "data-test-subj": `inspectorRequestDetail${detail.name}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, detail.label))), /*#__PURE__*/_react.default.createElement(selectedDetail.component, {
    key: props.request.id,
    request: props.request,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  })) : null;
}