"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineStructureTree = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _create_tree_nodes = require("./create_tree_nodes");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/ingest-pipelines/src/components/pipeline_structure_tree/pipeline_structure_tree.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * A component for a Pipeline structure tree.
 * Children pipeline nodes represent Pipeline processors that run the
 * corresponding pipelines from the children node.
 * See more at https://www.elastic.co/docs/reference/enrich-processor/pipeline-processor
 */
const PipelineStructureTree = exports.PipelineStructureTree = /*#__PURE__*/_react.default.memo(({
  pipelineTree,
  selectedPipeline,
  isExtension,
  clickTreeNode,
  clickMorePipelines,
  goBack
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _styles.getStyles)(euiTheme);
  const treeNode = (0, _create_tree_nodes.createTreeNodesFromPipelines)(pipelineTree, selectedPipeline, clickTreeNode, clickMorePipelines);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isExtension && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    onClick: goBack,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "ingestPipelines.pipelineStructureTree.backToMainTreeNodeLabel",
    defaultMessage: "Back to previous pipelines",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTreeView, {
    items: [treeNode],
    showExpansionArrows: true,
    css: styles,
    "aria-label": _i18n.i18n.translate('ingestPipelines.pipelineStructureTree.treeAriaLabel', {
      defaultMessage: 'Pipeline structure'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }));
});