"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineFormError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _i18n_texts = require("./i18n_texts");
var _error_utils = require("./error_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_form/pipeline_form_error/pipeline_form_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const numberOfErrorsToDisplay = 5;
const PipelineFormError = ({
  error
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const [isShowingAllErrors, setIsShowingAllErrors] = (0, _react.useState)(false);
  const safeErrorResult = (0, _error_utils.toKnownError)(error);
  const hasMoreErrors = safeErrorResult.errors.length > numberOfErrorsToDisplay;
  const hiddenErrorsCount = safeErrorResult.errors.length - numberOfErrorsToDisplay;
  const results = isShowingAllErrors ? safeErrorResult.errors : safeErrorResult.errors.slice(0, numberOfErrorsToDisplay);
  const renderErrorListItem = ({
    processorType,
    reason
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, processorType ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n_texts.i18nTexts.errors.processor(processorType) + ':', "\xA0") : undefined, reason);
  };
  (0, _react.useEffect)(() => {
    services.notifications.toasts.addDanger({
      title: _i18n_texts.i18nTexts.title
    });
  }, [services, error]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n_texts.i18nTexts.title,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "savePipelineError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, results.length > 1 ? /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, results.map((e, idx) => /*#__PURE__*/_react.default.createElement("li", {
    key: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 15
    }
  }, renderErrorListItem(e)))) : renderErrorListItem(results[0]), hasMoreErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "xs",
    justifyContent: "center",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, isShowingAllErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => setIsShowingAllErrors(false),
    color: "danger",
    iconSide: "right",
    iconType: "arrowUp",
    "data-test-subj": "hideErrorsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 17
    }
  }, _i18n_texts.i18nTexts.errors.hideErrors(hiddenErrorsCount)) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => setIsShowingAllErrors(true),
    color: "danger",
    iconSide: "right",
    iconType: "arrowDown",
    "data-test-subj": "showErrorsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  }, _i18n_texts.i18nTexts.errors.showErrors(hiddenErrorsCount)))) : undefined), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
};
exports.PipelineFormError = PipelineFormError;