"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inventoryViewSavedObjectRT = exports.inventoryViewSavedObjectAttributesRT = exports.inventorySavedObjectViewOptionsRT = exports.inventorySavedObjectSortOptionRT = exports.inventorySavedObjectOptionsStateRT = exports.inventorySavedObjectFiltersStateRT = exports.inventorySavedObjectColorPaletteRT = exports.inventorySabedObjectMapBoundsRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/metrics-data-access-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventorySavedObjectColorPaletteRT = exports.inventorySavedObjectColorPaletteRT = rt.keyof({
  status: null,
  temperature: null,
  cool: null,
  warm: null,
  positive: null,
  negative: null
});
const inventorySavedObjectLegendOptionsRT = rt.type({
  palette: inventorySavedObjectColorPaletteRT,
  steps: (0, _ioTsUtils.inRangeRt)(2, 18),
  reverseColors: rt.boolean
});
const inventorySavedObjectSortOptionRT = exports.inventorySavedObjectSortOptionRT = rt.type({
  by: rt.keyof({
    name: null,
    value: null
  }),
  direction: rt.keyof({
    asc: null,
    desc: null
  })
});
const inventorySavedObjectViewOptionsRT = exports.inventorySavedObjectViewOptionsRT = rt.keyof({
  table: null,
  map: null
});
const inventorySabedObjectMapBoundsRT = exports.inventorySabedObjectMapBoundsRT = rt.type({
  min: (0, _ioTsUtils.inRangeRt)(0, 1),
  max: (0, _ioTsUtils.inRangeRt)(0, 1)
});
const inventorySavedObjectFiltersStateRT = exports.inventorySavedObjectFiltersStateRT = rt.type({
  kind: rt.literal('kuery'),
  expression: rt.string
});
const inventorySavedObjectOptionsStateRT = exports.inventorySavedObjectOptionsStateRT = rt.intersection([rt.type({
  accountId: rt.string,
  autoBounds: rt.boolean,
  boundsOverride: inventorySabedObjectMapBoundsRT,
  customMetrics: rt.UnknownArray,
  customOptions: rt.array(rt.type({
    text: rt.string,
    field: rt.string
  })),
  groupBy: rt.UnknownArray,
  metric: rt.UnknownRecord,
  nodeType: _common.ItemTypeRT,
  region: rt.string,
  sort: inventorySavedObjectSortOptionRT,
  view: inventorySavedObjectViewOptionsRT
}), rt.partial({
  legend: inventorySavedObjectLegendOptionsRT,
  source: rt.string,
  timelineOpen: rt.boolean
})]);
const inventoryViewSavedObjectAttributesRT = exports.inventoryViewSavedObjectAttributesRT = rt.intersection([inventorySavedObjectOptionsStateRT, rt.type({
  name: _ioTsUtils.nonEmptyStringRt,
  autoReload: rt.boolean,
  filterQuery: inventorySavedObjectFiltersStateRT
}), rt.partial({
  time: rt.number,
  isDefault: rt.boolean,
  isStatic: rt.boolean
})]);
const inventoryViewSavedObjectRT = exports.inventoryViewSavedObjectRT = rt.intersection([rt.type({
  id: rt.string,
  attributes: inventoryViewSavedObjectAttributesRT
}), rt.partial({
  version: rt.string,
  updated_at: _ioTsUtils.isoToEpochRt
})]);