"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _ebtTools = require("@kbn/ebt-tools");
var _no_data_config = require("../../../components/shared/templates/no_data_config");
var _infra_page_template = require("../../../components/shared/templates/infra_page_template");
var _with_metrics_explorer_options_url_state = require("../../../containers/metrics_explorer/with_metrics_explorer_options_url_state");
var _use_metrics_explorer_views = require("../../../hooks/use_metrics_explorer_views");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _empty_states = require("../../../components/empty_states");
var _charts = require("./components/charts");
var _toolbar = require("./components/toolbar");
var _use_metric_explorer_state = require("./hooks/use_metric_explorer_state");
var _translations = require("../../../translations");
var _saved_views = require("./components/saved_views");
var _use_metrics_explorer_options = require("./hooks/use_metrics_explorer_options");
var _metrics_in_discover_callout = require("./components/metrics_in_discover_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metrics_explorer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsExplorerPage = () => {
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer',
    delay: 15000
  });
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.metricsExplorerTitle
  }]);
  return /*#__PURE__*/_react.default.createElement(_use_metrics_explorer_options.MetricsExplorerOptionsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_with_metrics_explorer_options_url_state.WithMetricsExplorerOptionsUrlState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(MetricsExplorerContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
};
exports.MetricsExplorerPage = MetricsExplorerPage;
const MetricsExplorerContent = () => {
  const [enabled, setEnabled] = (0, _react.useState)(false);
  const {
    isLoading,
    error,
    data,
    timeRange,
    options,
    chartOptions,
    setChartOptions,
    handleAggregationChange,
    handleMetricsChange,
    handleFilterQuerySubmit,
    handleGroupByChange,
    handleTimeChange,
    handleLoadMore,
    onViewStateChange,
    refresh
  } = (0, _use_metric_explorer_state.useMetricsExplorerState)({
    enabled
  });
  const {
    currentView
  } = (0, _use_metrics_explorer_views.useMetricsExplorerViews)();
  const prevDataRef = (0, _react.useRef)(data);
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'metrics_explorer',
    delay: 15000
  });
  (0, _react.useEffect)(() => {
    if (currentView) {
      onViewStateChange(currentView);
    }
  }, [currentView, onViewStateChange]);
  (0, _react.useEffect)(() => {
    if (currentView != null) {
      // load metrics explorer data after default view loaded, unless we're not isLoading a view
      setEnabled(true);
    }
  }, [currentView]);
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.metricsExplorerTitle
  }]);
  const viewState = {
    options,
    chartOptions,
    currentTimerange: timeRange
  };
  (0, _react.useEffect)(() => {
    if (!isLoading && data && prevDataRef.current !== data) {
      onPageReady({
        meta: {
          rangeFrom: timeRange.from,
          rangeTo: timeRange.to
        }
      });
      prevDataRef.current = data;
    }
  }, [isLoading, data, timeRange.from, timeRange.to, onPageReady]);
  const onFilter = query => {
    handleFilterQuerySubmit({
      query: {
        query,
        language: 'kuery'
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_infra_page_template.InfraPageTemplate, {
    onboardingFlow: _no_data_config.OnboardingFlow.Infra,
    pageHeader: {
      pageTitle: _translations.metricsExplorerTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_saved_views.SavedViews, {
        viewState: viewState,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 26
        }
      })]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_metrics_in_discover_callout.MetricsInDiscoverCallout, {
    timeRange: timeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_toolbar.MetricsExplorerToolbar, {
    timeRange: timeRange,
    options: options,
    chartOptions: chartOptions,
    onRefresh: refresh,
    onTimeChange: handleTimeChange,
    onGroupByChange: handleGroupByChange,
    onFilterQuerySubmit: handleFilterQuerySubmit,
    onMetricsChange: handleMetricsChange,
    onAggregationChange: handleAggregationChange,
    onChartOptionsChange: setChartOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), error ? /*#__PURE__*/_react.default.createElement(_empty_states.NoData, {
    titleText: "Whoops!",
    bodyText: _i18n.i18n.translate('xpack.infra.metricsExplorer.errorMessage', {
      defaultMessage: 'It looks like the request failed with "{message}"',
      values: {
        message: error.message
      }
    }),
    onRefetch: refresh,
    refetchText: "Try Again",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_charts.MetricsExplorerCharts, {
    timeRange: timeRange,
    isLoading: isLoading,
    data: data,
    options: options,
    chartOptions: chartOptions,
    onLoadMore: handleLoadMore,
    onFilter: onFilter,
    onRefetch: refresh,
    onTimeChange: handleTimeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }));
};