"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AwsS3Layout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _section = require("../section");
var _sub_section = require("../sub_section");
var _chart_section_vis = require("../chart_section_vis");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/layouts/aws_s3_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AwsS3Layout = exports.AwsS3Layout = (0, _eui.withEuiTheme)(({
  metrics,
  onChangeRangeTime,
  theme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_section.Section, {
  navLabel: "AWS S3",
  sectionLabel: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.overviewSection.sectionLabel', {
    defaultMessage: 'Aws S3 Overview'
  }),
  metrics: metrics,
  onChangeRangeTime: onChangeRangeTime,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsS3BucketSize",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.bucketSize.sectionLabel', {
    defaultMessage: 'Bucket Size'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "bytes",
  seriesOverrides: {
    bytes: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.bucketSize.chartLabel', {
        defaultMessage: 'Total Bytes'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsS3NumberOfObjects",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.numberOfObjects.sectionLabel', {
    defaultMessage: 'Number of Objects'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    objects: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.numberOfObjects.chartLabel', {
        defaultMessage: 'Objects'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsS3TotalRequests",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.totalRequests.sectionLabel', {
    defaultMessage: 'Total Requests'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    total: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.totalRequests.chartLabel', {
        defaultMessage: 'Requests'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsS3DownloadBytes",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.downloadBytes.sectionLabel', {
    defaultMessage: 'Downloaded Bytes'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "bytes",
  seriesOverrides: {
    bytes: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.downloadBytes.chartLabel', {
        defaultMessage: 'Bytes'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 108,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsS3UploadBytes",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.uploadBytes.sectionLabel', {
    defaultMessage: 'Uploaded Bytes'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "bytes",
  seriesOverrides: {
    bytes: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.s3MetricsLayout.uploadBytes.chartLabel', {
        defaultMessage: 'Bytes'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 131,
    columnNumber: 11
  }
})))));